#include <bonus.h>

Graph* Bonus::graph=NULL;


Bonus::Bonus(int value_,int x_, int y_,Edge* edge_):QGraphicsItem(0),value(value_),x(x_),y(y_), myEdge(edge_)
{
	setPos(-20*myEdge->myView->scale,-20*myEdge->myView->scale);
	consumed=0;
	scale=1;
	visible=1;
	
	objectType=bonus;
}


QRectF Bonus::boundingRect() const
{
	return QRectF(0,0,20*myEdge->myView->scale,20*myEdge->myView->scale);
}

void Bonus::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
{

	if (!visible)
		return;

	painter->save();
	painter->setOpacity(0.4);
	painter->setBrush(Qt::green);
	painter->drawEllipse(boundingRect());
	painter->restore();

}


void Bonus::advance(int step)
{

	if (!step)
		return;
	
	centerX=x-10*myEdge->myView->scale;
	centerY=y-10*myEdge->myView->scale;
	setTransformOriginPoint(10*myEdge->myView->scale,10*myEdge->myView->scale);
	setPos(centerX,centerY);
	setScale(scale);
	if (consumed)
		scale+=0.1;

	if (scale>2)
	{
		myEdge->deleteMe(this);
	}

}

void Bonus::hit()
{
	if (consumed==0 && myEdge->myView->graph->currentTime<myEdge->myView->graph->time)
		++myEdge->myView->graph->currentTime;
 	
	consumed=1;
	
}

