import Qt 4.7
import "mfakecaller.js" as FakeCallerScript
//import QtQuick 1.0


Rectangle {
    signal callAnswered;
    signal startVibration;
    signal stopVibration;
    signal callEnd;
    signal showMax;
    //signal startRingtone;
    //signal stopRingtone;

    id: main_rectangle
    width: 2880
    height: 800
    color: "#000000"
    x: 0
    y: 0

    property string thisCallerID: "Private number"
    onThisCallerIDChanged:{
        console.log("thisCallerID has changed:", thisCallerID, ", state: ", state);
        //fake_caller_text.text = thisCallerID;
    }
    property string thisCallerPicPath: "qrc:/caller_image.png"
    onThisCallerPicPathChanged:{
        console.log("thisCallerPicPath has changed:", thisCallerPicPath, ", state: ", state);
    }
    property string thisRingTonePath: "/home/user/MyDocs/.sounds/Ringtones/Lumina.aac"
    onThisRingTonePathChanged:{
        console.log("thisRingTonePath has changed:", thisRingTonePath, ", state: ", state);
    }
    property string thisWallPaperPath: "Default"
    onThisWallPaperPathChanged:{
        console.log("thisWallPaperPath has changed:", thisWallPaperPath, ", state: ", state);
    }
    property string useDefaultPic: "true"
    property string useDefaultWallpaper: "true"
    function setDefaults(){
        console.log("setting defaults")
        thisCallerID = callHelper.getCallID()
        thisCallerPicPath = callHelper.getCallerPicPath()
        thisRingTonePath = callHelper.getRingTone()
        thisWallPaperPath = callHelper.getWallPaperPath()
        useDefaultPic = FakeCallerScript.isCallPicDefault(thisCallerPicPath)
        useDefaultWallpaper = FakeCallerScript.isWallPaperDefault(thisWallPaperPath)
        console.log(useDefaultWallpaper)
    }

    Rectangle {
        id: help_screen
        width: 480
        height:  800
        x: 1440
        y: 0
        visible: false

        Rectangle {
            id: help_rect
            color: "#d2e8e8"
            anchors.fill: parent


            Rectangle {
                id: settings_header_rect1
                x: 0
                width: 481
                height: 80
                anchors.top: parent.top
                anchors.topMargin: 0
                Text {
                    id: help_title
                    x: 201
                    y: 14
                    width: 80
                    height: 20
                    color: "#ffffff"
                    text: "Help & Information"
                    horizontalAlignment: Text.AlignHCenter
                    smooth: true
                    anchors.horizontalCenter: parent.horizontalCenter
                    anchors.top: parent.top
                    anchors.topMargin: 14
                    font.underline: false
                    font.strikeout: false
                    anchors.horizontalCenterOffset: 0
                    font.italic: false
                    styleColor: "#000000"
                    font.bold: false
                    font.pointSize: 32
                }
                anchors.leftMargin: 0
                gradient: Gradient {
                    GradientStop {
                        position: 0
                        color: "#67828f"
                    }

                    GradientStop {
                        position: 0.5
                        color: "#000000"
                    }
                }
                anchors.left: parent.left
            }

            MouseArea {
                id: mouse_area1
                opacity: 1
                anchors.fill: parent
                onClicked:{
                    main_rectangle.state = "settings_menu_display"
                }
            }

            Rectangle {
                id: rectangle4
                x: 23
                y: 80
                width: 434
                height: 714
                color: "#00000000"
                anchors.horizontalCenter: parent.horizontalCenter

                Text {
                    id: text2
                    x: 0
                    y: 16
                    width: 434
                    height: 20
                    color: "#000000"
                    text: "<b>Pre-Release version 0.2</b><p>Thank you for trying mFakeCaller. It's currently still in development"
                    wrapMode: Text.WordWrap
                    font.pointSize: 17
                }

                Text {
                    id: text3
                    x: 0
                    y: 130
                    width: 434
                    height: 20
                    text: "<b>Help and instructions</b><p>Please see the mFakeCaller Maemo.org thread at:"
                    wrapMode: Text.WordWrap
                    font.pointSize: 17
                }

                Text {
                    id: text4
                    x: 0
                    y: 227
                    width: 434
                    height: 20
                    text: "http://talk.maemo.org/showthread.php?t=65241"
                    style: Text.Normal
                    wrapMode: Text.WordWrap
                    font.pointSize: 15
                }
                Text {
                    id: text5
                    x: 0
                    y: 270
                    width: 80
                    height: 20
                    text: "<b>Credits</b><p>Developer: Ryan (Kojacker)<p> Follow updates at twitter.com/kojacker"
                    font.pointSize: 17
                }

                Text {
                    id: text6
                    x: 0
                    y: 390
                    width: 434
                    height: 20
                    text: "The non-original menu icon images are taken from the Onebit icon set from icojoy.com, used under free license"
                    wrapMode: Text.WordWrap
                    font.pointSize: 16
                }




            }
        }
    }

    Rectangle {
        id: waiting_rect
        width: 480
        height: 800
        x: 0
        y: 0


        Rectangle {
            id: waiting_background_rect
            color: "#000000"
            anchors.fill: parent



            Rectangle {
                id: rectangle9
                x: 480
                y: 727
                width: 480
                height: 24
                color: "#ffffff"
            }


        }

        Text {
            id: waiting_text
            x: 10
            y: 2
            width: 460
            height: 20
            color: "#ffffff"
            text: "waiting.. <p><p><p>tap screen to cancel"
            opacity: 0.2
            style: Text.Normal
            smooth: true
            wrapMode: Text.WordWrap
            horizontalAlignment: Text.AlignLeft
            anchors.verticalCenterOffset: -387
            anchors.horizontalCenterOffset: 0
            font.pointSize: 38
            anchors.horizontalCenter: parent.horizontalCenter
                       anchors.verticalCenter: parent.verticalCenter
        }

        MouseArea{
            id: waitingregion; anchors.fill: parent;
            onClicked:{
                waiting_timer.running = "false"
                main_rectangle.state = "settings_menu_display"
            }
        }
    }

    Rectangle {
        id: settings_screen
        width: 480
        height:  800
        x: 481
        y: 0
        anchors.rightMargin: 0
        anchors.bottomMargin: 0
        anchors.leftMargin: 0
        anchors.topMargin: 0
        //anchors.fill: parent

        Rectangle {
            id: menu_background
            x: 0
            y: 9
           // x: 20
           // y: 28
            width: 480
            height: 758
            color: "#00000000"
            anchors.horizontalCenterOffset: 0
            anchors.horizontalCenter: parent.horizontalCenter
            border.width: 0
            border.color: "#d2e8e8"

            Image{
                id: carbon_background
                fillMode: Image.Tile
                source: "qrc:/image.jpg"
                anchors.fill: parent
            }


            Rectangle{
                id: settings_header_rect
                x: -1
                y: -9
                width: 480
                height: 80
                anchors.top: parent.top
                anchors.topMargin: -10
                gradient: Gradient {
                    GradientStop {
                        position: 0
                        color: "#67828f"
                    }

                    GradientStop {
                        position: 0.5
                        color: "#000000"
                    }
                }

            Text {
                id: settings_title
                x: 104
                y: 12

                width: 80
                height: 20
                color: "#ffffff"
                text: "Caller Settings"
                font.strikeout: false
                font.underline: false
                font.italic: false
                font.bold: false
                smooth: true
                styleColor: "#000000"
                anchors.horizontalCenterOffset: -96
                anchors.top: parent.top
                anchors.topMargin: 13
                anchors.horizontalCenter: parent.horizontalCenter
                font.pointSize: 32
            }
            }
            Rectangle{
                id: caller_settings_block
                x: 24
                y: 232
                width: 434
                height: 127
                color: "#00000000"
                visible: true
                anchors.horizontalCenterOffset: 1
                anchors.horizontalCenter: parent.horizontalCenter


            Image {
                id: callers_setting_img
                y: 53
                width: 48
                height: 48
                anchors.left: parent.left
                anchors.leftMargin: 0
                source: "qrc:/callers_setting_img.png"
            }
             //end caller settings rectangle


        Rectangle{
            id: caller_name_rect


        Text {
            id: caller_name_label
            x: 0
            y: 13
            width: 80
            height: 20
            color: "#000000"
            text: "Caller ID"
            smooth: true
            font.italic: false
            //anchors.top: callers_setting_img.bottom
            anchors.topMargin: -36
            font.pointSize: 25
        }

        Text {
            id: caller_display_description
            x: 52
            y: 106
            width: 80
            height: 20
            text: "the caller id, can be words, numbers, and symbols"
            anchors.left: parent.left
            anchors.leftMargin: 52
            anchors.top: parent.top
            anchors.topMargin: 106
            opacity: 0.6
            font.pointSize: 11
        }
        } // end caller name rect

        Rectangle{
            id: caller_image_rect
            x: 0
            y: -164
            width: 434
            height: 175
            color: "#00000000"
            radius: 1

        Text {
            id: caller_image_label
            x: 0
            y: 4
            width: 80
            height: 20
            color: "#000000"
            text: "Caller Images"
            smooth: true
            font.italic: false
            anchors.left: parent.left
            anchors.leftMargin: 0
            anchors.top: parent.top
            anchors.topMargin: 5
            font.pointSize: 25
        }


        Rectangle {
            id: polaroid_shadow_rect
            x: 80
            y: 50
            width: 94
            height: 110
            color: "#5a5959"
            opacity: 0.5
        }
        Rectangle {
            id: polaroid_rect
            x: 76
            y: 46
            width: 94
            height: 110
            color: "#ffffffff"
            border.width: 1
            border.color: "#000000"
            Image {
                id: caller_image_preview
                x: 4
                y: 4
                width: 86
                height: 98
                anchors.horizontalCenterOffset: 0
                anchors.horizontalCenter: parent.horizontalCenter
                anchors.top: parent.top
                anchors.topMargin: 3
                fillMode: Image.Stretch
                source: main_rectangle.thisCallerPicPath

                MouseArea{
                    id: callerpicregion; x: 2; y: 0; anchors.rightMargin: -1; anchors.bottomMargin: 0; anchors.leftMargin: 1; anchors.topMargin: 0; anchors.fill: parent;
                    onClicked:{
                        if (FakeCallerScript.isCallPicDefault(main_rectangle.thisCallerPicPath)=="true"){
                            console.log("calling select_caller_pic state with default image settings")
                            main_rectangle.state = "select_caller_pic"
                            main_rectangle.useDefaultPic="true"
                            //caller_pic_toggle_rect.buttonChoice ="default"
                            wanted_image_pic_path.text = "file:///home/user/MyDocs/.documents/..."
                        }
                        else{
                            main_rectangle.state = "find_caller_pic_state"
                            wanted_image_pic_path.text = main_rectangle.thisCallerPicPath
                            //caller_pic_toggle_rect.buttonChoice="notdefault"
                        }
                    }
                }
            }
        }

        Rectangle {
            id: wallpaper_shadow_rect
            x: 248
            y: 50
            width: 94
            height: 110
            color: "#5a5959"
            opacity: 0.5
        }
        Rectangle {
            id: wallpaper_rect
            x: 244
            y: 46
            width: 94
            height: 110
            color: "#ffffffff"
            border.width: 1
            border.color: "#000000"

            MouseArea{
                id: wallpaperpicregion; anchors.fill: parent;
                onClicked:{
                    if (main_rectangle.thisWallPaperPath=="Default"){
                        main_rectangle.state = "select_wallpaper_pic"
                        wallpaper_pic_toggle_rect.buttonChoice = "default"
                    }
                    else{
                        main_rectangle.state = "find_wallpaper_pic_state"
                        wallpaper_pic_toggle_rect.buttonChoice = "notdefault"
                    }
                }
            }
            Rectangle {
                id: default_wallpaper_gradient_rect
                x: 13
                y: -1
                width: 68
                height: 110
                visible: {
                    if (main_rectangle.thisWallPaperPath=="Default")
                        return true;
                    else
                        return false;
                }
                gradient: Gradient {
                    GradientStop {
                        position: 0
                        color: "#470b86"
                    }

                    GradientStop {
                        position: 0.36
                        color: "#070606"
                    }
                }
            }

            Image {
                id: wallpaper_image_preview
                x: 13
                y: -1
                width: 68
                height: 110
                anchors.horizontalCenterOffset: 0
                anchors.horizontalCenter: parent.horizontalCenter
                anchors.top: parent.top
                anchors.topMargin: 0
                fillMode: Image.Stretch
                source: main_rectangle.thisWallPaperPath
                visible: {
                    if (main_rectangle.thisWallPaperPath != "Default")
                        return true;
                    else
                        return false;
                }
            }
        }


        }

        Rectangle {
            id: rectangle1
            x: 0
            y: 137
            width: 434
            height: 2
            color: "#b7b3b3"
        }

        Rectangle {
            id: rectangle6
            x: -2
            y: 267
            width: 434
            height: 2
            color: "#b7b3b3"
            anchors.horizontalCenterOffset: 0
          //  anchors.horizontalCenter: settings_header_rect.horizontalCenter
        }

        Rectangle {
            id: rectangle7
            x: 0
            y: 409
            width: 434
            height: 2
            color: "#b7b3b3"
            anchors.horizontalCenterOffset: 1
          //  anchors.horizontalCenter: settings_header_rect.horizontalCenter
        }

        Rectangle {
            id: rectangle8
            x: -2
            y: 4
            width: 434
            height: 2
            color: "#b7b3b3"
           // anchors.horizontalCenter: settings_header_rect.horizontalCenter
            anchors.horizontalCenterOffset: 0
        }

        // end caller_image_rect

    } // end caller_settings_block



        Rectangle {
            id: bottom_menu_bar_rect
            x: -1
            y: 654
            width: 482
            height: 81
            gradient: Gradient {
                GradientStop {
                    position: 0
                    color: "#67828f"
                }

                GradientStop {
                    position: 0.5
                    color: "#000000"
                }
            }
        }





    }





        Rectangle {
            id: caller_name_input_rect
            x: 74
            y: 295
            width: 384
            height: 47
            radius: 5
            border.color: "#939292"
            gradient: Gradient {
                GradientStop {
                    position: 0.49
                    color: "#ffffff"
                }

                GradientStop {
                    position: 0
                    color: "#c8c8dd"
                }
            }
            anchors.top: parent.top
            anchors.topMargin: 294



            TextInput {

                id: caller_name_text_input

                color: "#151515";
                text: main_rectangle.thisCallerID;
                cursorVisible: false; anchors.rightMargin: 2; anchors.leftMargin: 2; anchors.bottomMargin: 1; anchors.topMargin: 1; anchors.fill: parent; selectionColor: "green"

                font.pixelSize: 33; font.bold: true


                maximumLength: 16


                focus: true

            }
        }


        Rectangle{
            id: ringtone_setting_block
            x:23
            y: 390
            width: 434
            height: 107
            color: "#00000000"
            anchors.horizontalCenterOffset: 0
            anchors.horizontalCenter: menu_background.horizontalCenter

        Rectangle {
            id: ringtone_input_rect
            x: 50
            y: 44
            gradient: Gradient {
                GradientStop {
                    position: 0.49
                    color: "#ffffff"
                }

                GradientStop {
                    position: 0
                    color: "#c8c8dd"
                }
            }
            width: 384
            height: 45
            radius: 5
            border.color: "#939292"
            anchors.top: parent.top
            anchors.topMargin: 43



            TextInput {

                id: ringtone_path_input

                color: "#151515";
                text: main_rectangle.thisRingTonePath;
                cursorVisible: false; anchors.rightMargin: 2; anchors.leftMargin: 2; anchors.bottomMargin: 1; anchors.topMargin: 1; anchors.fill: parent; selectionColor: "green"

                font.pixelSize: 33; font.bold: true


                //maximumLength: 16


                focus: true

            }
        }

        Image {
            id: image2
            x: 1
            y: 44
            width: 48
            height: 48
            anchors.left: parent.left
            anchors.leftMargin: 1
            anchors.top: parent.top
            anchors.topMargin: 43
            source: "qrc:/ringtone_settings_img.png"
        }
        Text {
            id: ringtone_label
            x: 0
            y: 0
            width: 80
            height: 20
            text: "Ringtone"
            smooth: true
            font.italic: false
            anchors.top: parent.top
            anchors.topMargin: 0
            font.pointSize: 25
        }

        Text {
            id: text1
            x: 50
            y: 91
            width: 80
            height: 20
            text: "please provide full path to the ringtone you wish to use"
            anchors.top: parent.top
            anchors.topMargin: 91
            wrapMode: Text.NoWrap
            opacity: 0.6
            font.pointSize: 11
        }
        } //end ringtone rectangle



 Rectangle{
            id: delay_setting_block
            x:23
            y: 502
            width: 434
            height: 135
            color: "#00000000"
            anchors.horizontalCenterOffset: 0
            anchors.horizontalCenter: menu_background.horizontalCenter
            anchors.top: parent.top
            anchors.topMargin: 503



        Text {
            id: delay_label
            x: 0
            y: 15
            width: 80
            height: 20
            text: "Delay (secs)"
            smooth: true
            font.italic: false
            anchors.top: parent.top
            anchors.topMargin: 15
            font.pointSize: 25
        }

        Image {
            id: delay_setting_img
            x: 2
            y: 60
            width: 48
            height: 48
            anchors.top: parent.top
            anchors.topMargin: 61
            source: "qrc:/delay_settings_img.png"
        }
        Text {
            id: delay_setting_description
            x: 51
            y: 127
            width: 380
            height: 20
            text: "slide how long to wait before the fake call begins"
            anchors.top: parent.top
            anchors.topMargin: 126
            wrapMode: Text.WordWrap
            opacity: 0.6
            font.pointSize: 11
        }

        Rectangle{
            //id: upDownDelayRect
            id: delayslider;
              width: 380; height: 65;
              color: "#00000000"
              anchors.verticalCenterOffset: 24
              anchors.horizontalCenterOffset: 29
              anchors.centerIn: parent
              property int value: Math.round(handle.x*95/(delayslider.width-handle.width))+5
              x: 57
              y: 57
              Rectangle{
                  id: slider_rail
                  x:0
                  height: 30
                  color: "#f1f0f0"
                  radius: 2
                  border.width: 2
                  anchors.verticalCenter: parent.verticalCenter
                  border.color: "#939292"
                  width: delayslider.width


              Rectangle{
                  id: slider_highlight
                  radius: 2
                  border.width: 2
                  gradient: Gradient {
                      GradientStop {
                          position: 0
                          color: "#2c7bc4"
                      }

                      GradientStop {
                          position: 0.48
                          color: "#499bf9"
                      }
                  }
                  border.color: "#939292"
                  anchors.left: parent.left
                  anchors.leftMargin: 0
                  anchors.bottom: parent.bottom
                  anchors.bottomMargin: 0
                  anchors.top: parent.top
                  anchors.topMargin: 0
                  width: handle.x+5

              }
              }
              Rectangle {
                id: handle; width: 65; height: 65
                radius: 5
                gradient: Gradient {
                    GradientStop {
                        position: 0
                        color: "#67828f"
                    }

                    GradientStop {
                        position: 0.5
                        color: "#000000"
                    }
                }
                MouseArea {
                  anchors.fill: parent
                  drag.target: parent; drag.axis: "XAxis"
                  drag.minimumX: 0; drag.maximumX: delayslider.width - handle.width

                }

                Text {
                    id: text12
                    x: 19
                    y: 12
                    color: "#ffffff"
                    text: delayslider.value
                    anchors.centerIn: parent
                    font.pointSize: 13
                }
              }

        }
        } //end delay setting rectangle





/*
    Rectangle {
        id: rectangle2
        x: 74
        y: 259
        width: 383
        height: 45
        gradient: Gradient {
            GradientStop {
                position: 0.49
                color: "#ffffff"
            }

            GradientStop {
                position: 0
                color: "#c8c8dd"
            }
        }
        radius: 5


        TextInput {

            id: caller_image_path_input

            color: "#151515";
            text: main_rectangle.thisCallerPicPath;
            cursorVisible: false; anchors.rightMargin: 2; anchors.leftMargin: 2; anchors.bottomMargin: 1; anchors.topMargin: 1; anchors.fill: parent; selectionColor: "green"

            font.pixelSize: 33; font.bold: true

            //maximumLength: 16



        }
    }*/
    //}

    Rectangle {
        id: aboutbutton_rect
        x: 25
        y: 657
        width: 175
        height: 85

        radius: 8
        gradient: Gradient {
            GradientStop {
                position: 0
                color: "#67828f"
            }

            GradientStop {
                position: 0.5
                color: "#000000"
            }
        }
        anchors.horizontalCenterOffset: -127
        anchors.horizontalCenter: parent.horizontalCenter

        MouseArea{
            id: aboutregion; anchors.fill: parent;
            onClicked:{
                main_rectangle.state = "show_help"
            }
        }

        Text {
            id: about_button_text
            x: 34
            y: 10
            width: 80
            height: 20
            color: "#fdfdfd"
            text: "Help"
            anchors.verticalCenterOffset: -24
            anchors.horizontalCenterOffset: -14
            anchors.centerIn: parent
            font.pointSize: 40
        }


    }


    Rectangle {
        id: gobutton_rect
        x: 278
        y: 657
        width: 175
        height: 85

        radius: 8
        gradient: Gradient {
            GradientStop {
                position: 0.42
                color: "#258427"
            }

            GradientStop {
                position: 0.01
                color: "#07ff0f"
            }

            GradientStop {
                position: 0
                color: "#f7f6f6"
            }
        }
        anchors.horizontalCenterOffset: 127
        anchors.horizontalCenter: parent.horizontalCenter

        MouseArea{
            id: region; anchors.fill: parent;
            onClicked:{
                main_rectangle.state = "waiting_status_display"
                main_rectangle.thisCallerID = caller_name_text_input.text
               // main_rectangle.thisCallerPicPath = FakeCallerScript.setCallerImage(caller_image_path_input.text)
                main_rectangle.thisRingTonePath =ringtone_path_input.text
            }
        }

        Text {
            id: ok_button_text
            x: 72
            y: 9
            width: 80
            height: 20
            color: "#fdfdfd"
            text: "Call"
            anchors.verticalCenterOffset: -24
            anchors.verticalCenter: parent.verticalCenter
            smooth: false
            font.pointSize: 40
        }

        Image {
            id: image3
            x: 20
            y: 18
            width: 48
            height: 48
            fillMode: Image.PreserveAspectFit
            source: "qrc:/call.png"
        }


    }

    }

    state: "startup_waiting"


    Timer {
        id: call_duration_timer
        interval: 1000; running: false; repeat: true
        onTriggered: {

            FakeCallerScript.updateCallDuration()
            call_duration_text.text = FakeCallerScript.callDurationString //FakeCallerScript.hours +":"+FakeCallerScript.minutes+":"+FakeCallerScript.seconds
        }
    }

    Timer {
        id: ringing_timer
        interval: 15000; running: false; repeat: false
        onTriggered: {
            console.log("ringing timer has ended")
            callHelper.stopVibration()
            callHelper.stopRingtone()
            callEnd()
        }
    }

    Timer {
        id: waiting_timer
        interval: 5000; running: true; repeat: false
        onTriggered:{
            showMax();
            console.log("timer has triggered")
            main_rectangle.state = "fake_call_display"
            console.log("state changed to fake_call_display")
            callAnswered()
            console.log("callanswered() signal sent")
            callHelper.startRingtone(thisRingTonePath)
            console.log("called startRingtone method of myObject")
            callHelper.setRingToneLoop(thisRingTonePath)
            console.log("setting ring tone loop")
            callHelper.startVibration()
            console.log("startVibration() signal sent")
            ringing_timer.running = "true"
            ringing_timer.interval = "15000"
            console.log("set ringing timer to running")
        }
    }

    states{
                State {
                    name: "startup_waiting"
                }
                State{
                    name: "waiting_status_display"
                    PropertyChanges {
                        target: main_rectangle
                        x: 0

                    }
                    //PropertyChanges {
                      //  target: settings_screen
                       // x: -480

                    // }
                   // PropertyChanges {
                     //   target: main_rectangle
                       // thisCallerID: caller_name_text_input.text

                    //}


                    PropertyChanges {
                        target: waiting_timer
                        interval: delayslider.value*1000
                        running: true

                    }
                    PropertyChanges {
                        target: ringing_timer
                        running: false

                    }
                }
                State {
                    name: "settings_menu_display"
                    PropertyChanges {
                        target: main_rectangle
                        x: -480
                    }
                    PropertyChanges {
                        target: ringing_timer
                        running: false

                    }
                }

                State {
                    name: "fake_call_display"

                    PropertyChanges {
                        target: main_rectangle
                        x: -960
                        z: 1

                    }

                    PropertyChanges {
                        target: call_screen_mask
                        opacity: 0

                    }

                 }
                 State {
                    name: "fake_call_answered"

                    PropertyChanges {
                        target: ringing_timer
                        running: false

                    }
                    PropertyChanges {
                        target: main_rectangle
                        x: -960
                        z: 1

                    }
                    PropertyChanges {
                        target: call_screen_mask
                        opacity: 0

                    }
                    PropertyChanges {
                        target: answer_grad_stop1
                        position: 0
                        color: "#585454"
                    }
                    PropertyChanges {
                        target: answer_grad_stop2
                        position: 0.44
                        color: "#272424"
                    }
                    PropertyChanges {
                        target: answerbutton_text
                        text: "Speaker"

                    }
                    PropertyChanges {
                        target: rejectbutton_text
                        text: "End"

                    }
                    PropertyChanges {
                        target: call_duration_text
                        visible: true

                    }
                    PropertyChanges{
                        target:  call_duration_timer
                        running: true
                    }

                }
                 State{
                     name: "show_help"
                     PropertyChanges {
                         target: main_rectangle
                         x: -1440
                     }
                     PropertyChanges {
                         target: help_screen
                         visible: true
                     }
                     PropertyChanges {
                         target: ringing_timer
                         running: false

                     }
                 }
                 State{
                     name: "select_caller_pic"
                     PropertyChanges {
                         target: main_rectangle
                         x: -1920
                     }
                     PropertyChanges {
                         target: image_path_finder_rect
                         y: 400

                     }
                     PropertyChanges {
                         target: caller_pic_screen
                         visible: true

                     }
                     PropertyChanges {
                         target: caller_pic_toggle_rect
                         buttonChoice: "default"
                     }
                     PropertyChanges {
                         target: ringing_timer
                         running: false

                     }
                 }
                 State{
                     name: "find_caller_pic_state"
                     PropertyChanges {
                         target: main_rectangle
                         x: -1920

                     }
                     PropertyChanges {
                         target: image_path_finder_rect
                         y: 193
                     }
                     PropertyChanges {
                         target: caller_pic_screen
                         visible: true

                     }
                     PropertyChanges {
                         target: caller_pic_toggle_rect
                         buttonChoice: "notdefault"

                     }
                     PropertyChanges{
                         target: image_path_finder_rect
                         opacity: 1.0
                     }
                     PropertyChanges {
                         target: ringing_timer
                         running: false

                     }
                 }

                 State{
                     name: "select_wallpaper_pic"
                     PropertyChanges {
                         target: main_rectangle
                         x: -2400
                     }
                     PropertyChanges{
                         target: wallpaper_image_path_finder_rect
                         y: 400
                     }
                     PropertyChanges {
                         target: wallpaper_pic_screen
                         visible: true

                     }
                     PropertyChanges{
                         target: wallpaper_pic_toggle_rect
                         buttonChoice: "default"
                     }
                     PropertyChanges {
                         target: ringing_timer
                         running: false

                     }
                 }
                 State {
                     name: "find_wallpaper_pic_state"
                     PropertyChanges {
                         target: main_rectangle
                         x: -2400
                     }
                     PropertyChanges {
                         target: wallpaper_image_path_finder_rect
                         y: 193

                     }
                     PropertyChanges {
                         target: wallpaper_pic_screen
                         visible: true

                     }
                     PropertyChanges {
                         target: wallpaper_pic_toggle_rect
                         buttonChoice: "notdefault"

                     }
                     PropertyChanges {
                         target: wallpaper_image_path_finder_rect
                         opacity: 1.0
                     }
                     PropertyChanges {
                         target: ringing_timer
                         running: false

                     }
                 }
    }

    transitions{
        Transition{
            from: "select_caller_pic"
            to: "find_caller_pic_state"
            PropertyAnimation{
                target: image_path_finder_rect
                property:  "y"
                duration:  500
                easing.type: "InBounce"
            }
        }
        Transition{
            from: "find_caller_pic_state"
            to: "select_caller_pic"
            PropertyAnimation{
                target: image_path_finder_rect
                property: "y"
                duration:  500
                easing.type: "OutBounce"
            }
        }
        Transition {
            from: "select_wallpaper_pic"
            to: "find_wallpaper_pic_state"
            PropertyAnimation{
                target: wallpaper_image_path_finder_rect
                property: "y"
                duration: 500
                easing.type:"InBounce"
            }

        }
        Transition {
            from: "find_wallpaper_pic_state"
            to: "select_wallpaper_pic"
            PropertyAnimation{
                target:  wallpaper_image_path_finder_rect
                property: "y"
                duration: 500
                easing.type:"OutBounce"
            }
        }

        Transition {
            from: "settings_menu_display"
            to: "waiting_status_display"

            PropertyAnimation {
                target:  main_rectangle
                property: "x"
                duration: 500
                easing.type:"Linear"

            }
           // PropertyAnimation{
           //     target:  main_rectangle
           //     property:  "x"
           //     duration:  1000
           //     easing.type:"OutSine"
           // }
        }
        Transition {
            from: "waiting_status_display"
            to: "fake_call_display"
            PropertyAnimation{
                target: call_screen_mask
                property:  "opacity"
                duration: 1000
                easing.type: "Linear"
            }

        }
        Transition {
            from: "startup_waiting"
            to: "fake_call_display"
            PropertyAnimation{
                target: call_screen_mask
                property:  "opacity"
                duration: 1000
                easing.type: "Linear"
            }

        }
        Transition {
        from: "startup_waiting"
        to: "settings_menu_display"
        PropertyAnimation{
            target:  main_rectangle
            property:  "x"
            duration: 400
            easing.type:"Linear"
        }

        }
        Transition{
        from: "fake_call_display"
        to: "settings_menu_display"
        PropertyAnimation{
            target:  main_rectangle
            property:  "x"
            duration:  500
            easing.type:"Linear"
        }
        PropertyAnimation{
            target: call_screen_mask
            property:  "opacity"
            duration: 400
            easing.type: "Linear"
        }
        }
        Transition{
        from: "fake_call_answered"
        to: "settings_menu_display"
        PropertyAnimation{
            target:  main_rectangle
            property:  "x"
            duration:  500
            easing.type:"Linear"
        }
        PropertyAnimation{
            target: call_screen_mask
            property:  "opacity"
            duration: 400
            easing.type: "Linear"
        }
        }

        Transition {
            from: "settings_menu_display"
            to: "show_help"
            PropertyAnimation{
                target: main_rectangle
                property: "x"
                duration:  0

            }

        }
        Transition {
            from: "show_help"
            to: "settings_menu_display"
            PropertyAnimation{
                target: main_rectangle
                property: "x"
                duration:  0

            }

        }
    }


    Rectangle {
        id: fake_call_background_rect
        width: 480
        height: 800
        x: 960
        y: 0
        //transformOrigin:"Center"
        //rotation: 270
        //anchors.centerIn: parent
        z: 1

        Rectangle {
            id: defaultWallpaperGradientRect
            visible: {
                if (main_rectangle.thisWallPaperPath == "Default")
                    return true;
                else
                    return false;
            }

            gradient: Gradient {
                GradientStop {
                    position: 0
                    color: "#470b86"
                }

                GradientStop {
                    position: 0.36
                    color: "#070606"
                }
            }

            anchors.fill: parent
        }

        Image {
            id: imageWallpaperRect

            visible: {
                if (main_rectangle.thisWallPaperPath != "Default")
                    return true;
                else
                    return false;
            }

            smooth: true
            fillMode: Image.Stretch

            source: main_rectangle.thisWallPaperPath
            anchors.fill: parent
        }

            Rectangle {
                id: caller_image_border
                x: 135
                y: 70
                height: 240
                width: 210
                color: "#afafaf"
                radius: 5
                anchors.top: parent.top
                anchors.topMargin: 92

                Image {
                    id: fake_caller_image
                    x: 2
                    y: 2
                    smooth: true
                    fillMode: Image.Stretch
                    anchors.fill: parent
                    anchors.rightMargin: 2
                    anchors.leftMargin: 2
                    anchors.bottomMargin: 2
                    anchors.topMargin: 2

                    source: {
                        if (main_rectangle.thisCallerPicPath == "Default")
                                return "qrc:/caller_image.png";
                        else return main_rectangle.thisCallerPicPath;
                    }
                }
            }

            Rectangle {
                id: answer_button_rect
                x: 30
                y: 551
                width: 421
                height: 91
                radius: 5

                gradient: Gradient {
                    GradientStop {
                        id: answer_grad_stop1
                        position: 0
                        color: "#28aa4d"
                    }

                    GradientStop {
                        id: answer_grad_stop2
                        position: 0.31
                        color: "#0b8622"
                    }
                }


                anchors.bottom: parent.bottom
                anchors.bottomMargin: 157

                Text {
                    id: answerbutton_text
                    x: 136
                    y: 13
                    color: "#ffffff"
                    text: "Answer"
                    anchors.centerIn: parent
                    smooth: true
                    font.pointSize: 29
                }
                MouseArea{
                    id: ansButtonRegion; anchors.fill: parent;


                    onClicked:{
                        callHelper.stopVibration()
                        callHelper.stopRingtone()
                        main_rectangle.state = "fake_call_answered"
                    }
                }
            }

            Rectangle {
                id: reject_button_rect
                height: 91
                radius: 5
                border.width: 0
                border.color: "#4b4b4b"
                gradient: Gradient {
                    GradientStop {
                        position: 0
                        color: "#d1483c"
                    }

                    GradientStop {
                        position: 1
                        color: "#690a0a"
                    }
                }
                x: 31
                y: 650
                width: 421
                anchors.bottom: parent.bottom
                anchors.bottomMargin: 58

                Text {
                    id: rejectbutton_text
                    x: 145
                    y: 17
                    color: "#ffffff"
                    text: "Reject"

                    anchors.centerIn: parent
                    smooth: true
                    font.pointSize: 29
                }
                MouseArea{
                    x: 0
                    y: -2
                    anchors.rightMargin: 0
                    anchors.bottomMargin: 1
                    anchors.leftMargin: 0
                    anchors.topMargin: -1
                    anchors.fill: parent
                    onClicked: {
                        callHelper.stopVibration()
                        callHelper.stopRingtone()
                        callEnd()
                    }
                }
            }

            Text {
                id: fake_caller_text
                x: 179
                width: 123
                height: 45
                color: "#ffffff"
                text: main_rectangle.thisCallerID
                //text: "Private Number"
                anchors.horizontalCenter: caller_image_border.horizontalCenter
                anchors.top: caller_image_border.bottom
                anchors.topMargin: 10
                font.pointSize: 30
                smooth: true
                horizontalAlignment: Text.AlignHCenter
            }

            Rectangle {
                id: left_button
                x: 30
                y: 475
                width: 208
                height: 71
                radius: 8
                gradient: Gradient {
                    GradientStop {
                        position: 0
                        color: "#585454"
                    }

                    GradientStop {
                        position: 0.44
                        color: "#272424"
                    }
                }
            }

            Rectangle {
                id: right_button
                x: 243
                y: 475
                width: 208
                height: 71
                radius: 8
                gradient: Gradient {
                    GradientStop {
                        position: 0
                        color: "#585454"
                    }

                    GradientStop {
                        position: 0.44
                        color: "#272424"
                    }
                }
                MouseArea{
                    id: rightbttnregion; anchors.fill: parent;
                    onClicked:{
                        callHelper.stopVibration()
                        callHelper.stopRingtone()
                        main_rectangle.state = "settings_menu_display"
                        FakeCallerScript.callDuration=0
                        call_duration_text.text="00:00:00"
                    }
                }
            }

            Image {
                id: microphone_image
                x: 117
                y: 486
                width: 48
                height: 48
                fillMode: Image.PreserveAspectFit
                anchors.horizontalCenter: left_button.horizontalCenter
                anchors.verticalCenter: left_button.verticalCenter
                source: "qrc:/microphone.png"
            }

            Image {
                id: keypad_image
                x: 318
                y: 486
                width: 48
                height: 48
                fillMode: Image.PreserveAspectFit
                anchors.horizontalCenter: right_button.horizontalCenter
                anchors.verticalCenter: right_button.verticalCenter
                source: "qrc:/keypad.png"
            }

            Rectangle {
                id: blue_square_region
                x: 133
                y: 88
                width: 37
                height: 39
                color: "#2232ea"

                Image {
                    id: image4
                    width: 30
                    height: 30
                    anchors.left: parent.left
                    anchors.leftMargin: 3
                    anchors.top: parent.top
                    anchors.topMargin: 4
                    smooth: true
                    source: "qrc:/call_answer.png"
                }
            }

            Rectangle {
                id: calltime_rect
                x: 135
                y: 390
                width: 210
                height: 36
                color: "#00000000"

                Text {
                    id: call_duration_text
                    color: "#ffffff"
                    text: "00:00:00"
                    font.pointSize: 15
                    horizontalAlignment: Text.AlignHCenter
                    anchors.fill: parent
                    visible: false
                }
            }

            Rectangle {
                id: call_screen_mask
                color: "#000000"
                opacity: 0.9
                anchors.fill: parent
            }


        //}
    }
    Rectangle {
        id: caller_pic_screen
        width: 480
        height:  800
        x: 1920
        y: 0
        visible: true

        Rectangle {
            id: call_pic_choice_rect
            x: 0
            y: 2
            color: "#d2e8e8"
            anchors.rightMargin: 0
            anchors.bottomMargin: -1
            anchors.leftMargin: 0
            anchors.topMargin: 1


            anchors.fill: parent

            Rectangle {
                id: call_pic_choice_header_rect1
                x: 0
                y: -2
                width: 481
                height: 80
                anchors.top: parent.top
                anchors.topMargin: -1
                Text {
                    id: callpicchoice_title
                    x: 201
                    y: 14
                    width: 80
                    height: 20
                    color: "#ffffff"
                    text: "Choose a Caller Pic"
                    horizontalAlignment: Text.AlignHCenter
                    smooth: true
                    anchors.horizontalCenter: parent.horizontalCenter
                    anchors.top: parent.top
                    anchors.topMargin: 14
                    font.underline: false
                    font.strikeout: false
                    anchors.horizontalCenterOffset: 0
                    font.italic: false
                    styleColor: "#000000"
                    font.bold: false
                    font.pointSize: 32
                }
                anchors.leftMargin: 0
                gradient: Gradient {
                    GradientStop {
                        position: 0
                        color: "#67828f"
                    }

                    GradientStop {
                        position: 0.5
                        color: "#000000"
                    }
                }
                anchors.left: parent.left
            }
            Rectangle {
                id: caller_choice_image_shadow
                x: 24
                y: 92
                height: 254
                width: 228
                color: "#ffffff"
                radius: 3
                border.width: 2
                border.color: "#000000"
                opacity: 1
                anchors.top: parent.top
                anchors.topMargin: 92
            }
            Rectangle {
                id: caller_choice_image_border
                y: 101
                height: 240
                width: 210
                color: "#afafaf"
                radius: 5
                anchors.left: caller_choice_image_shadow.right
                anchors.leftMargin: -219
                anchors.top: caller_choice_image_shadow.bottom
                anchors.topMargin: -249

                Image {
                    id: fake_caller_image_choice
                    x: 2
                    y: 1
                    smooth: true
                    fillMode: Image.Stretch
                    anchors.fill: parent
                    anchors.rightMargin: 2
                    anchors.leftMargin: 2
                    anchors.bottomMargin: 2
                    anchors.topMargin: 2

                    source: main_rectangle.thisCallerPicPath
                }
            }

            Rectangle {
                id: caller_pic_toggle_rect
                x: 23
                y: 366
                width: 434
                height: 361
                color: "#00000000"
                property string usedefault: "true"
                property string buttonChoice: "default"
                anchors.horizontalCenterOffset: 0
                anchors.horizontalCenter: parent.horizontalCenter

                Rectangle {
                    id: use_default_bttn_shadow
                    x: 4
                    y: 2
                    width: 434
                    height: 100
                    color: "#828181"
                    radius: 5
                    opacity: 0.5

                }

                Rectangle {
                    id: use_default_bttn
                    x: 41
                    y: -2
                    width: 434
                    height: 100
                    gradient: Gradient {
                        GradientStop {
                            id: usedefbttn_grad_stop1
                            position: 0
                            color: if (caller_pic_toggle_rect.buttonChoice =="default"){
                                       console.log("This should be painting green")
                                       "#28aa4d";
                                   }
                                    else "#585454";

                        }

                        GradientStop {
                            id: usedefbttn_grad_stop2
                            position: 0.31
                            color: if (caller_pic_toggle_rect.buttonChoice =="default")
                                       "#0b8622";
                                    else "#272424";
                        }
                    }
                    radius: 5
                    anchors.horizontalCenter: parent.horizontalCenter
                    MouseArea {
                        anchors.fill: parent
                        onClicked:{
                            //caller_pic_toggle_rect.toggleUseDefault()
                            image_path_finder_rect.opacity=0.2
                            //wanted_image_pic_path.text = "Default"
                            main_rectangle.state="select_caller_pic"
                            main_rectangle.thisCallerPicPath = FakeCallerScript.setCallerImage("Default")
                            main_rectangle.useDefaultPic = "true"
                            caller_pic_toggle_rect.buttonChoice = "default"
                        }
                    }

                    Text {
                        id: text7
                        x: 136
                        y: 28
                        width: 80
                        height: 20
                        color: "#ffffff"
                        text: "Use default"
                        anchors.verticalCenterOffset: -12
                        anchors.horizontalCenterOffset: 0
                        anchors.centerIn: parent
                        horizontalAlignment: Text.AlignHCenter
                        font.pointSize: 28
                    }
                }


                Rectangle {
                    id: find_image_bttn_shadow
                    x: 5
                    y: 117
                    width: 434
                    height: 100
                    color: "#828181"
                    radius: 5
                    opacity: 0.5
                    border.width: 0
                    border.color: "#000000"
                }
                Rectangle {
                    id: find_image_bttn
                    x: 0
                    y: 113
                    width: 434
                    height: 100
                    gradient: Gradient {
                        GradientStop {
                            id: findbttn_grad_stop1
                            position: 0
                            color: if (caller_pic_toggle_rect.buttonChoice =="default")
                                       "#585454";
                                    else "#28aa4d";
                        }

                        GradientStop {
                            id: findbttn_grad_stop2
                            position: 0.44
                            color: if (caller_pic_toggle_rect.buttonChoice =="default")
                                       "#272424";
                                    else "#0b8622";
                        }
                    }
                    radius: 5
                    anchors.horizontalCenterOffset: 0
                    anchors.horizontalCenter: parent.horizontalCenter
                    MouseArea {
                        anchors.fill: parent
                        onClicked:{
                            caller_pic_toggle_rect.buttonChoice = "notdefault"
                            image_path_finder_rect.opacity=1.0
                            main_rectangle.state="find_caller_pic_state"
                            //main_rectangle.useDefaultPic = "false"
                           // main_rectangle.thisCallerPicPath = FakeCallerScript.setCallerImage(wanted_image_pic_path.text)
                        }
                    }

                    Text {
                        id: text9
                        x: 136
                        y: 28
                        width: 80
                        height: 20
                        color: "#ffffff"
                        text: "Use image"
                        anchors.verticalCenterOffset: -12
                        anchors.horizontalCenterOffset: 0
                        anchors.centerIn: parent
                        font.pointSize: 28
                        horizontalAlignment: Text.AlignHCenter
                    }
                }


                Rectangle {
                    id: image_path_finder_rect
                    x: 0
                    y: 400
                    width: 434
                    height: 126
                    color: "#00000000"
                    visible: true
                    opacity: 0.2
                    anchors.horizontalCenterOffset: 0
                    anchors.horizontalCenter: parent.horizontalCenter
                   // visible:false

                    Rectangle {
                        id: wanted_image_input_rect
                        x: 6
                        y: 27
                        width: 424
                        height: 54
                        radius: 5
                        anchors.topMargin: 27
                        gradient: Gradient {
                            GradientStop {
                                position: 0.49
                                color: "#ffffff"
                            }

                            GradientStop {
                                position: 0
                                color: "#c8c8dd"
                            }
                        }
                        anchors.top: parent.top


                    TextInput {
                        id: wanted_image_pic_path
                        text: "file:///home/user/MyDocs/.documents/..."
                        horizontalAlignment: TextInput.AlignRight
                        anchors.fill: parent
                        selectedTextColor: "#ffffff"
                        font.pointSize: 30
                        cursorVisible: true
                    }

                    Image {
                        id: image5
                        x: 380
                        y: 57
                        width: 48
                        height: 48
                        anchors.verticalCenterOffset: 53
                        anchors.verticalCenter: parent.verticalCenter
                        source: "qrc:/search.png"
                        MouseArea {
                            x: 0
                            y: -1
                            anchors.rightMargin: 0
                            anchors.bottomMargin: 0
                            anchors.leftMargin: 0
                            anchors.topMargin: 0
                            anchors.fill: parent
                            onClicked:{
                                if (caller_pic_toggle_rect.buttonChoice != "default"){
                                main_rectangle.thisCallerPicPath = FakeCallerScript.setCallerImage(wanted_image_pic_path.text);
                                main_rectangle.useDefaultPic = "false"
                                }
                            }
                        }
                    }
                    }
                    Text {
                        id: caller_image_description1
                        x: 6
                        y: 85
                        width: 390
                        height: 20
                        text: "please provide full path to the image on your N900, e.g. file:///home/user/MyDocs/.documents/image.jpg"
                        anchors.top: parent.top
                        anchors.topMargin: 85
                        wrapMode: Text.WordWrap
                        font.pointSize: 11
                        anchors.leftMargin: 6
                        opacity: 0.6
                        anchors.left: parent.left
                    }
                }
            }


            Rectangle {
                id: rectangle5
                x: 312
                y: 92
                width: 144
                height: 85
                gradient: Gradient {
                    GradientStop {
                        position: 0.42
                        color: "#258427"
                    }

                    GradientStop {
                        position: 0.01
                        color: "#07ff0f"
                    }

                    GradientStop {
                        position: 0
                        color: "#f7f6f6"
                    }
                }
                radius: 8
                border.color: "#000000"
                Image {
                    id: image1
                    x: 7
                    y: 20
                    width: 48
                    height: 48
                    anchors.centerIn: parent
                    source: "qrc:/green_tick.png"
                }
                MouseArea{
                    id: image_pic_ok_bttn; anchors.fill: parent;
                    onClicked:{
                        main_rectangle.state = "settings_menu_display"
                    }
                }


            }

        }
    }

    Rectangle {
        id: wallpaper_pic_screen
        width: 480
        height:  800
        x: 2400
        y: 0
        visible: false

        Rectangle {
            id: wallpaper_choice_rect
            x: -1
            y: 1
            color: "#d2e8e8"
            radius: 0
            border.width: 0
            border.color: "#000000"
            anchors.rightMargin: 0
            anchors.bottomMargin: -1
            anchors.leftMargin: 0
            anchors.topMargin: 1
            anchors.fill: parent

            Rectangle {
                id: wallpaper_choice_header_rect1
                x: 0
                y: 0
                width: 481
                height: 80
                anchors.top: parent.top
                anchors.topMargin: -1
                Text {
                    id: wallpaperchoice_title
                    x: 201
                    y: 14
                    width: 80
                    height: 20
                    color: "#ffffff"
                    text: "Choose a Background"
                    horizontalAlignment: Text.AlignHCenter
                    smooth: true
                    anchors.horizontalCenter: parent.horizontalCenter
                    anchors.top: parent.top
                    anchors.topMargin: 14
                    font.underline: false
                    font.strikeout: false
                    anchors.horizontalCenterOffset: 0
                    font.italic: false
                    styleColor: "#000000"
                    font.bold: false
                    font.pointSize: 32
                }
                anchors.leftMargin: 0
                gradient: Gradient {
                    GradientStop {
                        position: 0
                        color: "#67828f"
                    }

                    GradientStop {
                        position: 0.5
                        color: "#000000"
                    }
                }
                anchors.left: parent.left
            }
            Rectangle {
                id: wallpaper_choice_image_shadow
                x: 24
                y: 93
                height: 254
                width: 228
                color: "#ffffff"
                radius: 3
                border.width: 2
                border.color: "#000000"
                opacity: 1
                anchors.top: parent.top
                anchors.topMargin: 93
            }
            Rectangle {
                id: wallpaper_choice_image_border
                x: 65
                y: 100
                height: 240
                width: 146
                color: "#afafaf"
                radius: 5
                anchors.verticalCenterOffset: -180
                anchors.verticalCenter: parent.verticalCenter
                anchors.horizontalCenterOffset: 0
                anchors.horizontalCenter: wallpaper_choice_image_shadow.horizontalCenter

                Rectangle {
                    id: wallpaper_gradient_rect_display
                    x: 0
                    y: -8
                    width: 146
                    height: 240
                    anchors.centerIn: parent
                    visible: {
                        if (main_rectangle.useDefaultWallpaper == "true")
                            return true;
                        else
                            return false;
                    }

                    gradient: Gradient {
                        GradientStop {
                            position: 0
                            color: "#470b86"
                        }

                        GradientStop {
                            position: 0.36
                            color: "#070606"
                        }
                    }
                }

                Image {
                    id: wallpaper_image_choice
                    x: 0
                    y: 0
                    width: 146
                    height: 240
                    anchors.centerIn: parent
                    visible: {
                        if (main_rectangle.useDefaultWallpaper = "false")
                            return true;
                        else
                            return false;
                    }

                    smooth: true
                    fillMode: Image.Stretch

                    source: main_rectangle.thisWallPaperPath
                }
            }

            Rectangle {
                id: wallpaper_pic_toggle_rect
                x: 23
                y: 366
                width: 434
                height: 361
                color: "#00000000"
                property string buttonChoice: "default"
                property string usedefault: "true"
                anchors.horizontalCenterOffset: 0
                anchors.horizontalCenter: parent.horizontalCenter

                Rectangle {
                    id: use_default_wallpaper_bttn_shadow
                    x: 4
                    y: 2
                    width: 434
                    height: 100
                    color: "#828181"
                    radius: 5
                    opacity: 0.5

                }

                Rectangle {
                    id: use_default_wallpaper_bttn
                    x: 41
                    y: -2
                    width: 434
                    height: 100
                    gradient: Gradient {
                        GradientStop {
                            id: usedefaultwallpaperbttn_grad_stop1
                            position: 0
                            color: if (wallpaper_pic_toggle_rect.buttonChoice =="default")
                                       "#28aa4d";
                                    else "#585454";
                        }

                        GradientStop {
                            id: usedefaultwallpaperbttn_grad_stop2
                            position: 0.44
                            color: if (wallpaper_pic_toggle_rect.buttonChoice =="default")
                                       "#0b8622";
                                    else "#272424";
                        }
                    }
                    radius: 5
                    anchors.horizontalCenter: parent.horizontalCenter
                    MouseArea {
                        anchors.fill: parent
                        onClicked:{
                            wallpaper_pic_toggle_rect.buttonChoice ="default"
                            wallpaper_image_path_finder_rect.opacity=0.2
                            main_rectangle.state="select_wallpaper_pic"
                            //wanted_image_pic_path.text = "Default"
                            main_rectangle.useDefaultWallpaper = "true"
                            main_rectangle.thisWallPaperPath = "Default"

                        }
                    }

                    Text {
                        id: default_wallpaper_bttn_text
                        x: 136
                        y: 28
                        width: 80
                        height: 20
                        color: "#ffffff"
                        text: "Use default"
                        anchors.verticalCenterOffset: -12
                        anchors.horizontalCenterOffset: 0
                        anchors.centerIn: parent
                        horizontalAlignment: Text.AlignHCenter
                        font.pointSize: 28
                    }
                }


                Rectangle {
                    id: find_wallpaper_image_bttn_shadow
                    x: 5
                    y: 117
                    width: 434
                    height: 100
                    color: "#828181"
                    radius: 5
                    opacity: 0.5
                    border.width: 0
                    border.color: "#000000"
                }
                Rectangle {
                    id: find_wallpaper_image_bttn
                    x: 0
                    y: 113
                    width: 434
                    height: 100
                    gradient: Gradient {
                        GradientStop {
                            id: findwallpaperbttn_grad_stop1
                            position: 0
                            color: if (wallpaper_pic_toggle_rect.buttonChoice =="notdefault")
                                       "#28aa4d";
                                    else "#585454";
                        }

                        GradientStop {
                            id: findwallpaperbttn_grad_stop2
                            position: 0.44
                            color: if (wallpaper_pic_toggle_rect.buttonChoice =="notdefault")
                                       "#0b8622";
                                    else "#272424";
                        }
                    }
                    radius: 5
                    anchors.horizontalCenterOffset: 0
                    anchors.horizontalCenter: parent.horizontalCenter
                    MouseArea {
                        anchors.fill: parent
                        onClicked:{
                            wallpaper_pic_toggle_rect.buttonChoice = "notdefault"
                            wallpaper_image_path_finder_rect.opacity=1.0
                            main_rectangle.state="find_wallpaper_pic_state"
                            //main_rectangle.thisWallPaperPath = FakeCallerScript.setCallerImage(wanted_image_pic_path.text)
                        }
                    }

                    Text {
                        id: find_wallpaper_image_bttn_text
                        x: 136
                        y: 28
                        width: 80
                        height: 20
                        color: "#ffffff"
                        text: "Find image"
                        anchors.verticalCenterOffset: -12
                        anchors.horizontalCenterOffset: 0
                        anchors.centerIn: parent
                        font.pointSize: 28
                        horizontalAlignment: Text.AlignHCenter
                    }
                }


                Rectangle {
                    id: wallpaper_image_path_finder_rect
                    x: 0
                    y: 400
                    width: 434
                    height: 126
                    color: "#00000000"
                    opacity: 0.2
                    anchors.horizontalCenterOffset: 0
                    anchors.horizontalCenter: parent.horizontalCenter
                   // visible:false

                    Rectangle {
                        id: wanted_wallpaper__image_input_rect
                        x: 6
                        y: 27
                        width: 424
                        height: 54
                        radius: 5
                        anchors.topMargin: 27
                        gradient: Gradient {
                            GradientStop {
                                position: 0.49
                                color: "#ffffff"
                            }

                            GradientStop {
                                position: 0
                                color: "#c8c8dd"
                            }
                        }
                        anchors.top: parent.top


                    TextInput {
                        id: wanted_wallpaper_image_pic_path
                        text: "file:///home/user/MyDocs/.documents/..."
                        horizontalAlignment: TextInput.AlignRight
                        anchors.fill: parent
                        selectedTextColor: "#ffffff"
                        font.pointSize: 30
                        cursorVisible: true
                    }

                    Image {
                        id: wallpaper_search_icon
                        x: 380
                        y: 60
                        width: 48
                        height: 48
                        anchors.verticalCenterOffset: 56
                        anchors.verticalCenter: parent.verticalCenter
                        source: "qrc:/search.png"
                        MouseArea {
                            x: 0
                            y: -1
                            anchors.rightMargin: 0
                            anchors.bottomMargin: 0
                            anchors.leftMargin: 0
                            anchors.topMargin: 0
                            anchors.fill: parent
                            onClicked:{
                                if (wallpaper_pic_toggle_rect.buttonChoice == "notdefault"){
                                main_rectangle.thisWallPaperPath = FakeCallerScript.setCallerImage(wanted_wallpaper_image_pic_path.text);
                                main_rectangle.useDefaultWallpaper = "false"
                                }
                            }
                        }
                    }
                    }
                    Text {
                        id: wallpaper_image_description1
                        x: 6
                        y: 85
                        width: 390
                        height: 20
                        text: "please provide full path to the image on your N900, e.g. file:///home/user/MyDocs/.documents/image.jpg"
                        anchors.top: parent.top
                        anchors.topMargin: 85
                        wrapMode: Text.WordWrap
                        font.pointSize: 11
                        anchors.leftMargin: 6
                        opacity: 0.6
                        anchors.left: parent.left
                    }
                }
            }

            Rectangle {
                id: wallpaper_ok_bttn
                x: 312
                y: 93
                width: 144
                height: 85
                gradient: Gradient {
                    GradientStop {
                        position: 0.42
                        color: "#258427"
                    }

                    GradientStop {
                        position: 0.01
                        color: "#07ff0f"
                    }

                    GradientStop {
                        position: 0
                        color: "#f7f6f6"
                    }
                }
                radius: 8
                border.color: "#000000"
                Image {
                    id: wallpaper_ok_btnn_greentick_img
                    x: 7
                    y: 20
                    width: 48
                    height: 48
                    anchors.centerIn: parent
                    source: "qrc:/green_tick.png"
                }
                MouseArea{
                    id: wallpaper_pic_ok_bttn; anchors.fill: parent;
                    onClicked:{
                        main_rectangle.state = "settings_menu_display"
                    }
                }


            }

        }
    }
}



