#include <QtGui/QApplication>
#include "mainwindow.h"

#include <QDeclarativeEngine>
#include "qdeclarative.h"

/*
 mFakeCaller main.cpp
 Calls main mFakeCaller form (mainwindow.cpp)
 Written by Ryan Faulkner (Kojacker, maemo.org forums)
 Email ryanfprojects at gmail.com
 7 Dec 2010
 */

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    QStringList args = app.arguments();
    app.setApplicationName("Call");
    MainWindow mainWindow;
    mainWindow.setOrientation(MainWindow::LockPortrait);

    if (args.count() >= 2)
    {
        mainWindow.setCallerNameLabel(args[1]);
    }
    if (args.count() >= 3)
    {
        mainWindow.setCallerPicLabel(args[2]);
    }
    if (args.count() >= 4)
    {
        mainWindow.setCallRingTone(args[3]);
    }
    if (args.count() >= 5)
    {
        mainWindow.setCallWallpaper(args[4]);
    }

    mainWindow.setCallerDefaults();
#ifdef Q_OS_SYMBIAN
    mainWindow.showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    mainWindow.showMaximized();
#else
    mainWindow.show();
#endif
    return app.exec();
}
