#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <phonon>
#include <QtDBus>

extern Phonon::MediaObject *mediaObject;

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT


public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();
    QTimer *release_timer;


public slots:
    void answerButtonClicked();
    void rejectButtonClicked();
    void leftUnassignedButtonClicked();
    void repeatRingTone();
    void stopVibration();
    void updateCallDuration();
    void setCallerNameLabel(QString name);
    void setCallerPicLabel(QString picpath);
    void setCallRingTone(QString tonepath);
    void setBackgroundStyleSheet(QString backgroundStyles);

protected:
    void changeEvent(QEvent *e);

private:
    Ui::MainWindow *ui;
    Phonon::MediaObject *mediaObject;

    int callDuration;
    QDBusInterface *mDbusInterface;
    QString callerName;
    QString ringTonePath; // = "/home/user/MyDocs/.sounds/Ringtones/Low.aac";
};

#endif // MAINWINDOW_H
