#include <QtGui/QApplication>
#include "mainwindow.h"

/*
 mFakeCaller main.cpp
 Calls main mFakeCaller form (mainwindow.cpp)
 Written by Ryan Faulkner (Kojacker, maemo.org forums)
 Email ryanfprojects at gmail.com
 7 Nov 2010
 */


int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    QStringList args = a.arguments();
    a.setApplicationName("mFakeCaller");
    MainWindow w;
    if (args.count() >= 2)
    {
        w.setCallerNameLabel(args[1]);
    }
    if (args.count() >= 3)
    {
        w.setCallerPicLabel(args[2]);
    }
    if (args.count() >= 4)
    {
        w.setCallRingTone(args[3]);
    }
    else{
        w.setCallRingTone("/home/user/MyDocs/.sounds/Ringtones/Lumina.aac");
    }
    if (args.count() >= 5)
    {
        w.setBackgroundStyleSheet(args[4]);
    }
    else{
        w.setBackgroundStyleSheet("background-color: qlineargradient(spread:pad, x1:0, y1:1, x2:0, y2:0, stop:0.607955 rgba(0, 0, 0, 255), stop:0.875 rgba(39, 0, 64, 255));");
    }
#if defined(Q_WS_S60)
    w.showMaximized();
#else
    w.show();
    w.release_timer->start();
#endif
    return a.exec();
}
