/*
 *  message blocker
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _MESSAGE_BLOCKER_SP_H_
#define _MESSAGE_BLOCKER_SP_H_

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

#define TYPE_MESSAGE_BLOCKER_STATUS_PUGIN (message_blocker_status_plugin_get_type())

#define MESSAGE_BLOCKER_STATUS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_MESSAGE_BLOCKER_STATUS_PUGIN, MessageBlockerStatusPlugin))
#define MESSAGE_BLOCKER_STATUS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_MESSAGE_BLOCKER_STATUS_PUGIN, MessageBlockerStatusPluginClass))
#define IS_MESSAGE_BLOCKER_STATUS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_MESSAGE_BLOCKER_STATUS_PUGIN))
#define IS_MESSAGE_BLOCKER_STATUS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_MESSAGE_BLOCKER_STATUS_PUGIN))

typedef struct _MessageBlockerStatusPlugin MessageBlockerStatusPlugin;
typedef struct _MessageBlockerStatusPluginClass MessageBlockerStatusPluginClass;
typedef struct _MessageBlockerStatusPluginPrivate MessageBlockerStatusPluginPrivate;

struct _MessageBlockerStatusPlugin
{
  HDStatusMenuItem parent;
  MessageBlockerStatusPluginPrivate* priv;
};

struct _MessageBlockerStatusPluginClass
{
  HDStatusMenuItemClass parent;
};

GType message_blocker_status_plugin_get_type(void);

G_END_DECLS
  
#endif
