/*
 *  message blocker
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _MESSAGE_BLOCKER_APPROVER_H_
#define _MESSAGE_BLOCKER_APPROVER_H_
#include <glib-object.h>
#include <glib.h>
#include <telepathy-glib/dbus-properties-mixin.h>

G_BEGIN_DECLS

#define TYPE_MESSAGE_BLOCKER_APPROVER (message_blocker_approver_get_type())
#define MESSAGE_BLOCKER_APPROVER(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_MESSAGE_BLOCKER_APPROVER, MessageBlockerApprover))
#define MESSAGE_BLOCKER_APPROVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_MESSAGE_BLOCKER_APPROVER, MessageBlockerApproverClass))
#define IS_MESSAGE_BLOCKER_APPROVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_MESSAGE_BLOCKER_APPROVER))
#define IS_MESSAGE_BLOCKER_APPROVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_MESSAGE_BLOCKER_APPROVER))
#define MESSAGE_BLOCKER_APPROVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_MESSAGE_BLOCKER_APPROVER, MessageBlockerApproverClass))

#define MESSAGE_BLOCKER_APPROVER_NAME "MessageBlockerApprover"
typedef struct _MessageBlockerApprover MessageBlockerApprover;
typedef struct _MessageBlockerApproverClass MessageBlockerApproverClass;
typedef struct _MessageBlockerApproverPrivate MessageBlockerApproverPrivate;

struct _MessageBlockerApprover
{
  GObject parent;
  MessageBlockerApproverPrivate* priv;
};

struct _MessageBlockerApproverClass
{
  GObjectClass parent_class;
  TpDBusPropertiesMixinClass dbus_props_class;
};

GType message_blocker_approver_get_type(void);

MessageBlockerApprover* message_blocker_approver_new(void);

void message_blocker_approver_set_block_list(MessageBlockerApprover* self, const gchar* account_name, GSList* block_list);
void message_blocker_approver_set_active(MessageBlockerApprover* self, gboolean active);

G_END_DECLS

#endif
