#ifndef SQL_H
#define SQL_H

#include <QtGui>
#include <QtSql>

#include "exercise.h"
#include "program.h"
#include "cardio.h"
#include "settings.h"
#include "exercisehistory.h"

class SQL
{
public:
    SQL();

    bool saveProgram(QString name, QStringList exercises);
    bool updateProgram(QString oldName,QString newName, QStringList exercises);
    bool updateProgramExercise(QString oldName,QString newName);
    Program* loadProgram(QString name);
    QStringList getProgramList();
    bool removeProgram(QString name);

    bool saveExercise(QString name, QString group, QString muscles, QString description);
    bool updateExercise(QString oldName,QString newName, QString group,
                        QString muscles, QString description);
    Exercise loadExercise(QString name);
    QStringList getExerciseList();
    QStringList getExerciseListByGroup(QString group);
    bool removeExercise(QString name);

    bool saveCardio(QString name);
    Cardio loadCardio(QString name);
    QStringList getCardioList();
    bool removeCardio(QString name);

    bool saveSettings(int vibrate, int sound, int volume, int sets, int minutes, int seconds);
    bool saveExerciseSettings(int sets, int minutes, int seconds);
    bool saveOtherSettings(int vibrate, int sound, int volume);
    Settings loadSettings();

    bool saveExerciseHistory(QString name, int weight, int set, int reps);
    QList<ExerciseHistory> loadExerciseHistoryByDate(QDate date);
    QStringList getHistoryDateList();
    QStringList getHistoryNameList();

private:
    bool openDB();
    bool initDB();

    QSqlDatabase db;
};

#endif // SQL_H
