#include "sql.h"

SQL::SQL()
{
    if(!openDB())
        QMessageBox::critical(0, qApp->tr("Cannot open database"),
                              qApp->tr("Unable to establish a database connection.\n"),
                              QMessageBox::Cancel);

    QStringList list = db.tables();
    if(list.isEmpty())
    {
        initDB();
    }
}
bool SQL::openDB()
{
    // Find QSLite driver
    db = QSqlDatabase::addDatabase("QSQLITE");
    db.setDatabaseName("meexercise.db.sqlite");

    // Open databasee
    return db.open();
}

bool SQL::initDB()
{
    if (db.isOpen())
    {
        QSqlQuery query;


        if(!query.exec("create table exercise (id int primary key, "
                       "name varchar(20),"
                       "groups varchar(20),"
                       "muscles varchar(20),"
                       "description varchar(2000))"))
        {
            qDebug() << "failed with init 1";
            return false;
        }

        if(!query.exec("create table cardio (id int primary key,"
                       "name varchar(20))"))
        {
            qDebug() << "failed with init 2";
            return false;
        }

        if(!query.exec("create table program (id int primary key,"
                       "name varchar(20),"
                       "exercise varchar(20))"))
        {
            qDebug() << "failed with init 3";
            return false;
        }

        if(!query.exec("create table programexercise (id int primary key,"
                       "program varchar(20),"
                       "exercise varchar(20))"))
        {
            qDebug() << "failed with init 4";
            return false;
        }

        if(!query.exec("create table exercisehistory (id int primary key,"
                       "date int,"
                       "name varchar(20),"
                       "weight int,"
                       "sets int,"
                       "reps int)"))
        {
            qDebug() << "failed with init 5";
            //return false;
        }

        if(!query.exec("create table settings (id int primary key,"
                       "vibrate int,"
                       "sound int,"
                       "volume int,"
                       "sets int,"
                       "minutes int,"
                       "seconds int)"))
        {
            qDebug() << "failed with init 6";
            //return false;
        }

        if(!query.exec("insert into settings values(1,0,0,0,1,1,0)"))
        {
            qDebug() << "failed with init 7";
            //return false;
        }

        return true;
    }
    return false;
}
bool SQL::saveProgram(QString name, QStringList exercises)
{
    if (db.isOpen())
    {
        QSqlQuery query;

        while(!exercises.isEmpty())
        {
            if(!query.exec(QString("insert into program values(NULL,'%1','%2')")
                .arg(name).arg(exercises.takeFirst())))
                return false;
        }
        return true;
    }
    return false;
}

bool SQL::updateProgram(QString oldName,QString newName, QStringList exercises)
{
    if (db.isOpen())
    {
        QSqlQuery query;
        while(!exercises.isEmpty())
        {
            if(!query.exec(QString("update program set program = '%1', "
                                   "exercise = '%2' where program = '%3'")
                .arg(newName).arg(exercises.takeFirst()).arg(oldName)))
                return false;
        }
        return true;
    }
    return false;
}

bool SQL::updateProgramExercise(QString oldName,QString newName)
{
    if (db.isOpen())
    {
        QSqlQuery query;
        if(!query.exec(QString("update program set exercise = '%1' where exercise = '%2'")
            .arg(newName).arg(oldName)))
            return false;

        return true;
    }
    return false;
}

Program* SQL::loadProgram(QString name)
{
    QSqlTableModel model;
    QList<Exercise> exercises;
    QString exercise;

    model.setTable("program");
    model.setFilter(QString("name = '%1'").arg(name));
    model.select();

    for (int i = 0; i < model.rowCount(); ++i)
    {
        QSqlRecord record = model.record(i);
        exercise = record.value("exercise").toString();
        exercises.append(loadExercise(exercise));
    }

    return new Program(name,exercises);
}

QStringList SQL::getProgramList()
{
    QSqlTableModel model;
    QStringList list;

    model.setTable("program");
    model.select();

    for (int i = 0; i < model.rowCount(); ++i)
    {
        QSqlRecord record = model.record(i);
        if(!list.contains(record.value("name").toString()))
            list.append(record.value("name").toString());
    }
    return list;
}

bool SQL::removeProgram(QString name)
{
    if (db.isOpen())
    {
        QSqlQuery query;

        if(!query.exec(QString("delete from program where name = '%1'").arg(name)))
            return false;

        return true;
    }
    return false;
}

bool SQL::saveExercise(QString name, QString group, QString muscles, QString description)
{
    if (db.isOpen())
    {
        QSqlQuery query;

        if(!query.exec(QString("insert into exercise values(NULL,'%1','%2','%3','%4')")
            .arg(name).arg(group).arg(muscles).arg(description)))
            return false;

        return true;
    }
    return false;
}

bool SQL::updateExercise(QString oldName,QString newName, QString group,
                    QString muscles, QString description)
{
    if (db.isOpen())
    {
        QSqlQuery query;

        if(!query.exec(QString("update exercise set name = '%1', "
                               "groups = '%2', muscles = '%3', "
                               "description = '%4' where name = '%5'")
                               .arg(newName).arg(group).arg(muscles)
                               .arg(description).arg(oldName)))
            return false;
        if(!updateProgramExercise(oldName,newName))
            return false;

        return true;
    }
    return false;
}

Exercise SQL::loadExercise(QString name)
{
    QSqlTableModel model;
    QString group, muscles, description;

    model.setTable("exercise");
    model.setFilter(QString("name = '%1'").arg(name));
    model.select();

    for (int i = 0; i < model.rowCount(); ++i)
    {
        QSqlRecord record = model.record(i);
        group = record.value("group").toString();
        muscles = record.value("muscles").toString();
        description = record.value("description").toString();

        return Exercise(name,group,muscles,description);
    }
}

QStringList SQL::getExerciseList()
{
    QSqlTableModel model;
    QStringList list;

    model.setTable("exercise");
    model.select();

    for (int i = 0; i < model.rowCount(); ++i)
    {
        QSqlRecord record = model.record(i);
        list.append(record.value("name").toString());
    }
    return list;
}

QStringList SQL::getExerciseListByGroup(QString group)
{
    QSqlTableModel model;
    QStringList list;

    model.setTable("exercise");
    model.setFilter(QString("groups = '%1'").arg(group));
    model.select();

    for (int i = 0; i < model.rowCount(); ++i)
    {
        QSqlRecord record = model.record(i);
        list.append(record.value("name").toString());
    }
    return list;
}

bool SQL::removeExercise(QString name)
{
    if (db.isOpen())
    {
        QSqlQuery query;

        if(!query.exec(QString("delete from exercise where name = '%1'").arg(name)))
            return false;

        return true;
    }
    return false;
}

bool SQL::saveCardio(QString name)
{
}
Cardio SQL::loadCardio(QString name)
{
}
QStringList SQL::getCardioList()
{
}

bool SQL::saveSettings(int vibrate, int sound, int volume, int sets, int minutes, int seconds)
{
    if (db.isOpen())
    {
        QSqlQuery query;

        if(!query.exec(QString("update settings set vibrate = %1,"
                               "sound = %2,"
                               "volume = %3,"
                               "sets = %4,"
                               "minutes = %5,"
                               "seconds = %6 "
                               "where id = 1")
            .arg(vibrate).arg(sound).arg(volume)
            .arg(sets).arg(minutes).arg(seconds)))
            return false;

        return true;
    }
    return false;
}

bool SQL::saveOtherSettings(int vibrate, int sound, int volume)
{
    if (db.isOpen())
    {
        QSqlQuery query;

        if(!query.exec(QString("update settings set vibrate = %1,"
                               "sound = %2,"
                               "volume = %3 "
                               "where id = 1")
            .arg(vibrate).arg(sound).arg(volume)))
            return false;

        return true;
    }
    return false;
}

bool SQL::saveExerciseSettings(int sets, int minutes, int seconds)
{
    if (db.isOpen())
    {
        QSqlQuery query;

        if(!query.exec(QString("update settings set sets = %4,"
                               "minutes = %5,"
                               "seconds = %6 "
                               "where id = 1")
            .arg(sets).arg(minutes).arg(seconds)))
            return false;

        return true;
    }
    return false;
}

Settings SQL::loadSettings()
{
    QSqlTableModel model;
    int vibrate, sound, volume, set, minutes, seconds;

    model.setTable("settings");
    model.setFilter("id = 1");
    model.select();

    for (int i = 0; i < model.rowCount(); ++i)
    {
        QSqlRecord record = model.record(i);
        vibrate = record.value("vibrate").toInt();
        sound = record.value("sound").toInt();
        volume = record.value("volume").toInt();
        set = record.value("sets").toInt();
        minutes = record.value("minutes").toInt();
        seconds = record.value("seconds").toInt();

        return Settings(vibrate,sound,volume,set,minutes,seconds);
    }
}

bool SQL::saveExerciseHistory(QString name, int weight, int set, int reps)
{
    QDate date = QDate().currentDate();
    int d = date.toString("ddMMyyyy").toInt();
    if (db.isOpen())
    {
        QSqlQuery query;

        if(!query.exec(QString("insert into exercisehistory "
                               "values(NULL,%1,'%2',%3,%4,%5)")
            .arg(d).arg(name).arg(weight).arg(set).arg(reps)))
            return false;

        return true;
    }
    return false;

}

QList<ExerciseHistory> SQL::loadExerciseHistoryByDate(QDate date)
{
    int d = date.toString("ddMMyyyy").toInt();
    QSqlTableModel model;
    QList<ExerciseHistory> exercises;
    QString name;
    QList<int> set;
    QList<int> weight;
    QList<int> reps;

    model.setTable("exercisehistory");
    model.setFilter(QString("date = %1").arg(d));
    model.select();

    for (int i = 0; i < model.rowCount(); ++i)
    {
        QSqlRecord record = model.record(i);
        if(name == "")
        {
            name = record.value("name").toString();
            set.append(record.value("sets").toInt());
            weight.append(record.value("weight").toInt());
            reps.append(record.value("reps").toInt());

        }
        else if(record.value("name").toString() != name)
        {
            exercises.append(ExerciseHistory(name,set,weight,reps));

            name = record.value("name").toString();
            set.clear();
            weight.clear();
            reps.clear();

            set.append(record.value("sets").toInt());
            weight.append(record.value("weight").toInt());
            reps.append(record.value("reps").toInt());
        }

        else if(record.value("name").toString() == name)
        {
            set.append(record.value("sets").toInt());
            weight.append(record.value("weight").toInt());
            reps.append(record.value("reps").toInt());
        }

    }

    exercises.append(ExerciseHistory(name,set,weight,reps));
    return exercises;
}

QStringList SQL::getHistoryDateList()
{
    QSqlTableModel model;
    QStringList dates;

    model.setTable("exercisehistory");
    model.select();

    for (int i = 0; i < model.rowCount(); ++i)
    {
        QSqlRecord record = model.record(i);
        if(!dates.contains(record.value("date").toString()))
            dates.append(record.value("date").toString());
    }
    return dates;
}

QStringList SQL::getHistoryNameList()
{
    QSqlTableModel model;
    QStringList names;

    model.setTable("exercisehistory");
    model.select();

    for (int i = 0; i < model.rowCount(); ++i)
    {
        QSqlRecord record = model.record(i);
        if(!names.contains(record.value("name").toString()))
            names.append(record.value("name").toString());
    }
    return names;
}

/*QList<ExerciseHistory> SQL::getHistoryByName(QString exercise)
{
    QSqlTableModel model;
    QList<ExerciseHistory> exercises;
    QString name;
    QList<int> set;
    QList<int> weight;
    QList<int> reps;

    model.setTable("exercisehistory");
    model.setFilter(QString("name = '%1'").arg(exercise));
    model.select();

    for (int i = 0; i < model.rowCount(); ++i)
    {
        QSqlRecord record = model.record(i);
        if(name == "")
        {
            name = record.value("name").toString();
            set.append(record.value("sets").toInt());
            weight.append(record.value("weight").toInt());
            reps.append(record.value("reps").toInt());

        }
        else if(record.value("name").toString() != name)
        {
            exercises.append(ExerciseHistory(name,set,weight,reps));

            name = record.value("name").toString();
            set.clear();
            weight.clear();
            reps.clear();

            set.append(record.value("sets").toInt());
            weight.append(record.value("weight").toInt());
            reps.append(record.value("reps").toInt());
        }

        else if(record.value("name").toString() == name)
        {
            set.append(record.value("sets").toInt());
            weight.append(record.value("weight").toInt());
            reps.append(record.value("reps").toInt());
        }

    }

    exercises.append(ExerciseHistory(name,set,weight,reps));
    return exercises;
}
*/
