#ifndef SELECTWEIGHT_H
#define SELECTWEIGHT_H

#include <QtGui>
#include "sql.h"

class SelectWeight : public QDialog
{
    Q_OBJECT
public:
    explicit SelectWeight(QWidget *parent = 0);
    void load(QString name, int currentSet);

signals:
    void next();

private slots:
    void save();

private:
    SQL *sql;

    void closeEvent(QCloseEvent *event);

    QRadioButton *radioEasy;
    QRadioButton *radioOK;
    QRadioButton *radioHard;

    QPushButton *btnSave;

    QStandardItemModel *modelReps;
    QStandardItemModel *modelKg;

    QListView *btnReps;
    QListView *btnKg;

    //QMaemo5ListPickSelector *selectorReps;
    //QMaemo5ListPickSelector *selectorVar;

    QHBoxLayout *hLayout;
    QVBoxLayout *buttonLayout;

    QString exerciseName;
    int reps, set;
    QString min, sec;
    bool close;

};

#endif // SELECTWEIGHT_H
