#include "selectweight.h"

SelectWeight::SelectWeight(QWidget *parent) :
    QDialog(parent)
{
    sql = new SQL();
    close = false;
    qDebug () << "WeightDialog::WeightDialog 1";

    //setWindowFlags(this->windowFlags() | Qt::Window);
    setWindowTitle("Save weight");

    hLayout = new QHBoxLayout();
    buttonLayout = new QVBoxLayout();
    qDebug () << "WeightDialog::WeightDialog 2";
    modelReps = new QStandardItemModel(this);
    for (int i = 1; i <= 25; i++)
        modelReps->appendRow(new QStandardItem(tr("%1").arg(i)));

    qDebug () << "WeightDialog::WeightDialog 3";
    btnReps = new QListView();
    btnReps->setModel(modelReps);
    buttonLayout->addWidget(btnReps);

    qDebug () << "WeightDialog::WeightDialog 4";

    btnKg = new QListView();
    modelKg = new QStandardItemModel(this);
    for (int i = 1; i < 200; i++)
        modelKg->appendRow(new QStandardItem(tr("%1").arg(i)+ "kg"));

    btnKg->setModel(modelKg);
    buttonLayout->addWidget(btnKg);

    hLayout->addLayout(buttonLayout);

    qDebug () << "WeightDialog::WeightDialog 5";

    radioEasy = new QRadioButton("Easy");
    radioOK = new QRadioButton("Perfect");
    radioHard = new QRadioButton("Hard");

    QVBoxLayout *vLayout = new QVBoxLayout();
    vLayout->addWidget(radioEasy);
    vLayout->addWidget(radioOK);
    vLayout->addWidget(radioHard);
    hLayout->addLayout(vLayout);

    btnSave = new QPushButton("Save");

    hLayout->addWidget(btnSave);

    setLayout(hLayout);
    //load();
    qDebug () << "WeightDialog::WeightDialog 6";
    connect(btnSave, SIGNAL(clicked()),this,SLOT(save()));
    qDebug () << "WeightDialog::WeightDialog 7";
    //resize(480,350);
}

void SelectWeight::load(QString name,int currentSet)
{
    QStringList list;
    qDebug () << "WeightDialog::load 1";

    exerciseName = name;
    set = currentSet;
    qDebug () << "WeightDialog::load 2";

    qDebug () << "WeightDialog::load 3";

    setWindowTitle("Save weight (set:" + QString().setNum(currentSet) + ")");

    /*list = xml->getHistoryByExercise(name);

    if(list.isEmpty())
        return;

    for(int i = 1; i < currentSet.toInt(); i++)
    {
        list.removeFirst();
        list.removeFirst();
        list.removeFirst();
    }

    btnVar->setValueText(list.takeFirst());
    btnReps->setValueText(list.takeFirst());



*/
    qDebug () << "WeightDialog::load 4";
}

void SelectWeight::save()
{
    qDebug () << "WeightDialog::save 1";
    QString status;
    int weight;

    if(radioOK->isChecked())
        status = "perfect";
    else if(radioEasy->isChecked())
        status = "easy";
    else if(radioHard->isChecked())
        status = "hard";
    else
    {
        //QMaemo5InformationBox::information(this, "You must select status.", QMaemo5InformationBox::DefaultTimeout);
        qDebug() << "Select status";
        return;
    }

    qDebug () << "WeightDialog::save 2";

    if(btnReps->selectionModel()->currentIndex().data().toString() == "")
    {
        //QMaemo5InformationBox::information(this, "You must select reps.", QMaemo5InformationBox::DefaultTimeout);
        qDebug() << "Select reps";
        return;
    }
    else if(btnKg->selectionModel()->currentIndex().data().toString() == "")
    {
        //QMaemo5InformationBox::information(this, "You must select weight.", QMaemo5InformationBox::DefaultTimeout);
        qDebug() << "Select weight";
        return;
    }

    qDebug () << "WeightDialog::save 3";
    QString wTemp = btnKg->selectionModel()->currentIndex().data().toString();
    wTemp = wTemp.remove("kg");
    weight = wTemp.toInt();
    reps = btnReps->selectionModel()->currentIndex().data().toInt();

    qDebug () << "WeightDialog::save 5";

    if(!sql->saveExerciseHistory(exerciseName,weight,set,reps))
    {
        qDebug() << "Saving history failed";
    }
    close = true;
    emit next();
    qDebug () << "WeightDialog::save 6";

    delete this;
}

void SelectWeight::closeEvent(QCloseEvent *event)
{
    if(close == false)
        return event->ignore();
}
