#include "othersettings.h"

OtherSettings::OtherSettings(QWidget *parent) :
    QDialog(parent)
{
    sql = new SQL();
    setWindowTitle("Other settings");

    QVBoxLayout *vLayout = new QVBoxLayout;

    chbVibrate = new QCheckBox("Vibrate");
    vLayout->addWidget(chbVibrate);

    chbSound = new QCheckBox("Sound");
    vLayout->addWidget(chbSound);


    QLabel *label = new QLabel("Volume");
    label->setSizePolicy(QSizePolicy::Minimum,QSizePolicy::Minimum);
    sliderVolume = new QSlider(Qt::Horizontal);
    sliderVolume->setRange(0,100);
    vLayout->addWidget(label);
    vLayout->addWidget(sliderVolume);

    setLayout(vLayout);
    load();
}

void OtherSettings::closeEvent(QCloseEvent *event)
{
    save();
}

void OtherSettings::save()
{
    int vibrate = 0, sound = 0, volume = 0;
    if(chbVibrate->isChecked())
        vibrate = 1;

    if(chbSound->isChecked())
        sound = 1;

    volume = sliderVolume->value();
    if(!sql->saveOtherSettings(vibrate,sound,volume))
        qDebug() << "Saving failed";
}

void OtherSettings::load()
{
    int vibrate = 0, sound = 0, volume = 0;
    Settings settings = sql->loadSettings();

    vibrate = settings.getVibration();
    sound = settings.getSound();
    volume = settings.getVolume();

    if(vibrate == 1)
        chbVibrate->setChecked(true);

    if(sound == 1)
        chbSound->setChecked(true);

    sliderVolume->setValue(volume);

}
