#include "newprogram.h"

NewProgram::NewProgram(QWidget *parent) :
    QMainWindow(parent)
{
    setWindowTitle("New program");
    sql = new SQL();

    QWidget *widget = new QWidget();

    vLayout = new QVBoxLayout();

    txtName = new QLineEdit();
    txtName->setPlaceholderText("Name");
    vLayout->addWidget(txtName);

    model = new QStandardItemModel();
    lstExercises = new QListView();
    lstExercises->setModel(model);
    lstExercises->setSelectionMode(QListView::MultiSelection);
    vLayout->addWidget(lstExercises);

    btnSave = new QPushButton("Save");
    connect(btnSave, SIGNAL(clicked()), this, SLOT(saveExercise()));
    vLayout->addWidget(btnSave);

    widget->setLayout(vLayout);
    setCentralWidget(widget);
    load();
}

void NewProgram::load(QString n)
{

}

void NewProgram::load()
{
    QStringList list;
    list = sql->getExerciseList();

    if(list.isEmpty())
    {
        model->appendRow(new QStandardItem ("No exercises"));
        lstExercises->setSelectionMode(QListView::NoSelection);
        return;
    }

    while(!list.isEmpty())
    {
        model->appendRow(new QStandardItem(list.takeFirst()));
    }
    model->sort(0);

}


void NewProgram::saveExercise()
{
    QStringList exercises;
    QModelIndexList list;

    QItemSelectionModel *m = lstExercises->selectionModel();
    list = m->selectedRows();
    while(!list.isEmpty())
    {
        exercises.append(list.takeFirst().data().toString());
    }
    if(!sql->saveProgram(txtName->text(),exercises))
        qDebug() << "Saving program failed";
}
