#include "newexercise.h"

NewExercise::NewExercise(QWidget *parent) :
    QDialog(parent)
{
    setWindowTitle("New exercise");

    //QWidget *widget = new QWidget();
    //setCentralWidget(widget);

    sql = new SQL();

    QVBoxLayout *vLayout = new QVBoxLayout();

    QHBoxLayout *txtLayout = new QHBoxLayout();

    txtName = new QLineEdit();
    txtName->setPlaceholderText("Name");
    txtMuscle = new QLineEdit();
    txtMuscle->setPlaceholderText("Muscle");
    txtHowTo = new QTextEdit("How to...");
    txtHowTo->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    txtLayout->addWidget(txtName);
    txtLayout->addWidget(txtMuscle);

    model = new QStandardItemModel(this);
    model->appendRow(new QStandardItem(tr("Arms")));
    model->appendRow(new QStandardItem(tr("Back")));
    model->appendRow(new QStandardItem(tr("Cardio")));
    model->appendRow(new QStandardItem(tr("Chest")));
    model->appendRow(new QStandardItem(tr("Legs")));
    model->appendRow(new QStandardItem(tr("Shoulder")));
    model->appendRow(new QStandardItem(tr("Stomach")));

    btnGroup = new QListView();
    btnGroup->setModel(model);
    //btnGroup->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    //selectorGroup = new QMaemo5ListPickSelector;
    //selectorGroup->setModel(model);
    //btnGroup->setPickSelector(selectorGroup);
    //btnGroup->setValueText("Arms");
    txtLayout->addWidget(btnGroup);

    btnSave = new QPushButton("Save");

    //vLayout->addWidget(txtName);
    vLayout->addLayout(txtLayout);
    //vLayout->addWidget(txtMuscle);
    //vLayout->addWidget(btnGroup);
    vLayout->addWidget(txtHowTo);

    vLayout->addWidget(btnSave);

    setLayout(vLayout);

    connect(btnSave, SIGNAL(clicked()),this, SLOT(saveExercise()));
}

void NewExercise::load(QString n)
{
    QModelIndex index;
    name = n;
    Exercise ex = sql->loadExercise(name);
    txtName->setText(ex.getName());
    txtMuscle->setText(ex.getMuscles());
    txtHowTo->setText(ex.getDescription());

    index = model->indexFromItem(new QStandardItem(ex.getGroup()));
    btnGroup->selectionModel()->setCurrentIndex(index,QItemSelectionModel::Select);
}

void NewExercise::saveExercise()
{
    if(name == "")
    {
        if(!sql->saveExercise(txtName->text(),
                              btnGroup->selectionModel()->currentIndex().data().toString(),
                              txtMuscle->text(),
                              txtHowTo->toPlainText()))
        {
            qDebug() << "Saving exercise failed";
        }
    }
    else
    {
        if(!sql->updateExercise(name,txtName->text(),
                                btnGroup->selectionModel()->currentIndex().data().toString(),
                                txtMuscle->text(),
                                txtHowTo->toPlainText()))
        {
            qDebug() << "Update exercise failed";
        }
    }

}
