#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>
#include "sql.h"
#include "groupwindow.h"
#include "settingswindow.h"
#include "exercisehistory.h"
#include "historywindow.h"
#include "advancewindow.h"

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    SQL *sql;
    GroupWindow *gw;
    SettingsWindow *sw;
    ListWindow *lw;
    HistoryWindow *hw;
    AdvanceWindow *aw;

    void createActions();
    void createMenu();
    QList <QString> getStats();

    QAction *settingsAction;
    QAction *historyAction;

    QPushButton *btnGroups;
    QPushButton *btnCardio;
    QPushButton *btnProgram;
    QPushButton *btnFood;

    QLabel *lblWeight;
    QLabel *lblCardio;

private slots:
    void showGroups();
    //void showCardio();
    void showProgram();

    void showHistory();
    void showSettings();
};

#endif // MAINWINDOW_H
