#include "mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent)
{
    QWidget *widget = new QWidget;
    setCentralWidget(widget);

    sql = new SQL();

    QVBoxLayout *vLayout = new QVBoxLayout;
    QHBoxLayout *hLabelLayout = new QHBoxLayout;
    lblWeight = new QLabel("Weight-lift/week \n 1000kg \n 3 times/week");
    lblCardio = new QLabel("Cardio/week \n 325km \n 5 times/week");

    lblWeight->setAlignment(Qt::AlignCenter);
    lblCardio->setAlignment(Qt::AlignCenter);

    hLabelLayout->addWidget(lblWeight);
    hLabelLayout->addWidget(lblCardio);

    QHBoxLayout *hButtonLayout = new QHBoxLayout;
    btnGroups = new QPushButton(QIcon(":/res/images/weight.png"),"",this);
    connect(btnGroups,SIGNAL(clicked()),this,SLOT(showGroups()));

    btnCardio = new QPushButton(QIcon(":/res/images/cardio.png"),"",this);
    connect(btnCardio,SIGNAL(clicked()),this,SLOT(showCardio()));

    btnProgram = new QPushButton(QIcon(":/res/images/program.png"),"",this);
    connect(btnProgram,SIGNAL(clicked()),this,SLOT(showProgram()));

    hButtonLayout->addWidget(btnGroups);
    hButtonLayout->addWidget(btnCardio);
    hButtonLayout->addWidget(btnProgram);
    hButtonLayout->addWidget(btnFood);

    vLayout->addLayout(hLabelLayout);
    vLayout->addLayout(hButtonLayout);

    widget->setLayout(vLayout);

    createActions();
    createMenu();
}

MainWindow::~MainWindow()
{

}

void MainWindow::showHistory()
{
    hw = new HistoryWindow(this);
    hw->show();
/*
    aw = new AdvanceWindow(this);
    aw->show();

    QStringList l;
    QList<ExerciseHistory> a;

    l = sql->getHistoryDateList();
    qDebug () << l;

    a = sql->loadExerciseHistoryByDate(QDate().fromString(l.takeFirst(),"ddMMyyyy"));
    while(!a.isEmpty())
    {
        ExerciseHistory b = a.takeFirst();
        qDebug() << b.getName() << b.getSet() << b.getWeight() << b.getReps();
    }
*/
}

void MainWindow::showGroups()
{
    gw = new GroupWindow(this);
    gw->show();
}

void MainWindow::showProgram()
{
    lw = new ListWindow(this);
    lw->loadPrograms();
    lw->show();
}

void MainWindow::showSettings()
{
    sw = new SettingsWindow(this);
    sw->show();
}



void MainWindow::createMenu()
{
    QMenu *menu;
    menu = menuBar()->addMenu(tr("&Menu"));
    menu->addAction(historyAction);
    menu->addAction(settingsAction);
}

void MainWindow::createActions()
{
    historyAction = new QAction("History",this);
    settingsAction = new QAction("Settings",this);

    connect(historyAction, SIGNAL(triggered()), this, SLOT(showHistory()));
    connect(settingsAction, SIGNAL(triggered()), this, SLOT(showSettings()));

}
