#include "listwindow.h"

ListWindow::ListWindow(QWidget *parent) :
    QMainWindow(parent)
{
    sql = new SQL();
    model = new QStandardItemModel(this);

    lstExercises = new QListView();
    lstExercises->setModel(model);

    //lstExercises->setContextMenuPolicy(Qt::CustomContextMenu);
    //connect(lstExercises, SIGNAL(customContextMenuRequested(const QPoint &)),SLOT(showContextMenuForWidget(const QPoint &)));

    setCentralWidget(lstExercises);
}

void ListWindow::loadExercises(QString grp)
{
    QStringList list;

    if(grp == "Cardio")
        list = sql->getCardioList();
    else
        list = sql->getExerciseListByGroup(grp);

    model->clear();
    lstExercises->setSelectionMode(QListView::SingleSelection);
    connect(lstExercises,SIGNAL(clicked(QModelIndex)),this,SLOT(showInfo(QModelIndex)));

    if(list.isEmpty())
    {
        model->appendRow(new QStandardItem ("No exercises"));

        lstExercises->setSelectionMode(QListView::NoSelection);
        return;
    }

    while(!list.isEmpty())
    {
        model->appendRow(new QStandardItem(list.takeFirst()));
    }

    model->sort(0);
}

void ListWindow::loadPrograms()
{
    QStringList list = sql->getProgramList();
    model->clear();
    lstExercises->setSelectionMode(QListView::SingleSelection);
    connect(lstExercises,SIGNAL(clicked(QModelIndex)),this,SLOT(showProgramInfo(QModelIndex)));
    if(list.isEmpty())
    {
        model->appendRow(new QStandardItem ("No programs"));
        lstExercises->setSelectionMode(QListView::NoSelection);
        return;
    }

    while(!list.isEmpty())
    {
        model->appendRow(new QStandardItem(list.takeFirst()));
    }

    model->sort(0);
}


void ListWindow::showInfo(QModelIndex index)
{
    iw = new InfoWindow(this);
    iw->loadExercise(index.data().toString());
    iw->show();
}

void ListWindow::showProgramInfo(QModelIndex index)
{
    pi = new ProgramInfo(this);
    pi->loadExercises(index.data().toString());
    pi->show();
}
