#include "historywindow.h"

HistoryWindow::HistoryWindow(QWidget *parent) :
    QMainWindow(parent)
{
    sql = new SQL();
    model = new QStandardItemModel(this);

    lstDates = new QListView();
    lstDates->setModel(model);
    connect(lstDates,SIGNAL(clicked(QModelIndex)),this,SLOT(openDay(QModelIndex)));
    //lstExercises->setContextMenuPolicy(Qt::CustomContextMenu);
    //connect(lstExercises, SIGNAL(customContextMenuRequested(const QPoint &)),SLOT(showContextMenuForWidget(const QPoint &)));

    setCentralWidget(lstDates);

    load();
}

void HistoryWindow::openDay(QModelIndex index)
{
    dh = new DayHistory(this);
    dh->loadHistory(index.data().toString());
    dh->show();
}

void HistoryWindow::load()
{
    QStringList dates;
    QStandardItem *item;

    dates = sql->getHistoryDateList();

    while(!dates.isEmpty())
    {
        item = new QStandardItem(dates.takeFirst());
        model->appendRow(item);
    }
}
