#include "groupwindow.h"

GroupWindow::GroupWindow(QWidget *parent) :
    QMainWindow(parent)
{
    QWidget *widget = new QWidget;
    setCentralWidget(widget);

    QGridLayout *gridLayout = new QGridLayout();

    btnArms = new QPushButton("Arms");
    connect(btnArms,SIGNAL(clicked()),this,SLOT(showArmsList()));
    btnBack = new QPushButton("Back");
    connect(btnBack,SIGNAL(clicked()),this,SLOT(showBackList()));
    btnChest = new QPushButton("Chest");
    connect(btnChest,SIGNAL(clicked()),this,SLOT(showChestList()));
    btnLegs = new QPushButton("Legs");
    connect(btnLegs,SIGNAL(clicked()),this,SLOT(showLegsList()));
    btnShoulder = new QPushButton("Shoulder");
    connect(btnShoulder,SIGNAL(clicked()),this,SLOT(showShoulderList()));
    btnStomach = new QPushButton("Stomach");
    connect(btnStomach,SIGNAL(clicked()),this,SLOT(showStomachList()));

    gridLayout->addWidget(btnArms,1,1);
    gridLayout->addWidget(btnBack,1,2);
    gridLayout->addWidget(btnChest,2,1);
    gridLayout->addWidget(btnLegs,2,2);
    gridLayout->addWidget(btnShoulder,3,1);
    gridLayout->addWidget(btnStomach,3,2);

    widget->setLayout(gridLayout);
}

void GroupWindow::showArmsList()
{
    lw = new ListWindow(this);
    lw->loadExercises("Arms");
    lw->show();
}
void GroupWindow::showBackList()
{
    lw = new ListWindow(this);
    lw->loadExercises("Back");
    lw->show();
}
void GroupWindow::showChestList()
{
    lw = new ListWindow(this);
    lw->loadExercises("Chest");
    lw->show();
}
void GroupWindow::showLegsList()
{
    lw = new ListWindow(this);
    lw->loadExercises("Legs");
    lw->show();
}
void GroupWindow::showShoulderList()
{
    lw = new ListWindow(this);
    lw->loadExercises("Shoulder");
    lw->show();
}
void GroupWindow::showStomachList()
{
    lw = new ListWindow(this);
    lw->loadExercises("Stomach");
    lw->show();
}
