#ifndef EXERCISEWINDOW_H
#define EXERCISEWINDOW_H

#include <QtGui>
#include "sql.h"
#include "settings.h"
#include "selectweight.h"
#include "selectexercise.h"

class ExerciseWindow : public QMainWindow
{
    Q_OBJECT
public:
    explicit ExerciseWindow(QWidget *parent = 0);
    void loadExercises(Program *program);

public slots:
    void loadExercise(QString exercise);

private:
    SQL *sql;
    SelectWeight *sw;
    SelectExercise *se;

    void loadTimer();
    void selectWeight();
    void selectExercise();
    bool openNextExercise();

    QWidget *widget;
    QVBoxLayout *vLayout;
    QLabel *label;
    QFont font;

    QPushButton *btnShake;
    QTimer *timer;

    int timeLeft;
    int set, currentSet;
    QString currentExercise;
    QStringList exercises;

signals:

private slots:
    void nextSet();
    void shaked();
    void startCountdown();
    void timerInterrupt();

};

#endif // EXERCISEWINDOW_H
