#include "editwindow.h"

EditWindow::EditWindow(QWidget *parent) :
    QMainWindow(parent)
{
    sql = new SQL();
    widget = new QWidget();
    setCentralWidget(widget);

    vBox = new QVBoxLayout();
    lstItems = new QListView();
    model = new QStandardItemModel(this);
    lstItems->setModel(model);
    vBox->addWidget(lstItems);

    hBox = new QHBoxLayout();
    btnAdd = new QPushButton(QIcon(":/res/images/Add.ico"),"",this);
    hBox->addWidget(btnAdd);

    btnEdit = new QPushButton(QIcon(":/res/images/Edit.ico"),"",this);
    hBox->addWidget(btnEdit);

    btnRemove = new QPushButton(QIcon(":/res/images/Delete.ico"),"",this);
    hBox->addWidget(btnRemove);

    vBox->addLayout(hBox);
    widget->setLayout(vBox);
    this->show();
}

void EditWindow::load(QString t)
{
    QStringList list;
    type = t;

    if(type == "Exercise")
    {
        connect(btnAdd,SIGNAL(clicked()),this,SLOT(addExercise()));
        connect(btnRemove,SIGNAL(clicked()),this,SLOT(removeExercise()));
        connect(btnEdit,SIGNAL(clicked()),this,SLOT(editExercise()));
        list = sql->getExerciseList();
    }

    else if(type == "Program")
    {
        connect(btnAdd,SIGNAL(clicked()),this,SLOT(addProgram()));
        connect(btnRemove,SIGNAL(clicked()),this,SLOT(removeProgram()));
        connect(btnEdit,SIGNAL(clicked()),this,SLOT(editProgram()));
        list = sql->getProgramList();
    }

    while(!list.isEmpty())
    {
        QStandardItem *item = new QStandardItem(list.takeFirst());
        model->appendRow(item);
    }
}

void EditWindow::addExercise()
{
    ne = new NewExercise(this);
    ne->show();
}

void EditWindow::editExercise()
{
    ne = new NewExercise(this);
    ne->load(lstItems->selectionModel()->currentIndex().data().toString());
    ne->show();
}

void EditWindow::removeExercise()
{
    QItemSelectionModel *selected;
    QModelIndexList indexList;

    selected = lstItems->selectionModel();
    indexList = selected->selectedIndexes();

    if(!sql->removeExercise(indexList.at(0).data().toString()))
        qDebug() << "Removing exercise failed";
}

void EditWindow::addProgram()
{
    np = new NewProgram(this);
    np->show();
}

void EditWindow::editProgram()
{
    np = new NewProgram(this);
    np->load(lstItems->selectionModel()->currentIndex().data().toString());
    np->show();
}

void EditWindow::removeProgram()
{
    QItemSelectionModel *selected;
    QModelIndexList indexList;

    selected = lstItems->selectionModel();
    indexList = selected->selectedIndexes();

    if(!sql->removeProgram(indexList.at(0).data().toString()))
        qDebug() << "Removing program failed";
}
