#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>
#include <QSettings>
#include <QValidator>

#include "ui_settingsdialog.h"

#include <QtGui/QX11Info>
#include <X11/Xlib.h>

namespace Ui {
    class SettingsDialog;
}

class SettingsDialog : public QDialog
{
    Q_OBJECT

protected:
    void showEvent(QShowEvent *se)
    {
        if (m_parent != None)
        {
            XSetTransientForHint(QX11Info::display(), winId(), m_parent);
        }
        QDialog::showEvent(se);
    }
    Window m_parent;

public:
    explicit SettingsDialog(Window parent, bool user);
    ~SettingsDialog();

private:
    Ui::SettingsDialog *ui;

private slots:
    void accept();
};

#endif // SETTINGSDIALOG_H
