#include "settingsdialog.h"

SettingsDialog::SettingsDialog(Window parent, bool user) :
    QDialog(0),
    m_parent(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    (void) user;
    if(parent)
        setAttribute(Qt::WA_X11BypassTransientForHint);
    this->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif
    ui->timeoutBox->setValidator(new QIntValidator(this));
    ui->autohideBox->setValidator(new QIntValidator(this));
    ui->timeoutBox->setText(QSettings().value("main/timeout").toString());
    ui->autohideBox->setText(QSettings().value("main/autohide-timeout").toString());
    ui->showMetadataCheckbox->setChecked(QSettings().value("main/showMetadata").toBool());
    ui->vibrateCheckbox->setChecked(QSettings().value("main/vibrate").toBool());
    ui->xPositionBox->setText(QSettings().value("main/x_coord").toString());
    ui->yPositionBox->setText(QSettings().value("main/y_coord").toString());
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::accept()
{
    QSettings().setValue("main/timeout", ui->timeoutBox->text().toInt());
    QSettings().setValue("main/autohide-timeout", ui->autohideBox->text().toInt());
    QSettings().setValue("main/showMetadata", ui->showMetadataCheckbox->isChecked());
    QSettings().setValue("main/vibrate", ui->vibrateCheckbox->isChecked());
    QSettings().setValue("main/x_coord", ui->xPositionBox->text().toInt());
    QSettings().setValue("main/y_coord", ui->yPositionBox->text().toInt());
    this->close();
}
