#include "settingsdialog.h"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif
    ui->timeoutBox->setValidator(new QIntValidator(this));
    ui->autohideBox->setValidator(new QIntValidator(this));
    ui->timeoutBox->setText(QSettings().value("main/timeout").toString());
    ui->autohideBox->setText(QSettings().value("main/autohide-timeout").toString());
    ui->showMetadataCheckbox->setChecked(QSettings().value("main/showMetadata").toBool());
    ui->vibrateCheckbox->setChecked(QSettings().value("main/vibrate").toBool());
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::accept()
{
    QSettings().setValue("main/timeout", ui->timeoutBox->text().toInt());
    QSettings().setValue("main/autohide-timeout", ui->autohideBox->text().toInt());
    QSettings().setValue("main/showMetadata", ui->showMetadataCheckbox->isChecked());
    QSettings().setValue("main/vibrate", ui->vibrateCheckbox->isChecked());
    this->close();
}
