#ifndef WIDGET_H
#define WIDGET_H

#include <QtGui>
#include <QSettings>
#ifndef Q_WS_MAEMO_5
    #include <QProximitySensor>
#else
    #include <QtDBus>
    #include "maemo5deviceevents.h"
    #include "mafwrendereradapter.h"
#endif

#include "ui_widget.h"

#define prevButtonIcon "/etc/hildon/theme/mediaplayer/Back.png"
#define playButtonIcon "/etc/hildon/theme/mediaplayer/Play.png"
#define pauseButtonIcon "/etc/hildon/theme/mediaplayer/Pause.png"
#define nextButtonIcon "/etc/hildon/theme/mediaplayer/Forward.png"

namespace Ui {
    class Widget;
}

class Widget : public QWidget
{
    Q_OBJECT
    Ui::Widget *ui;
#ifndef Q_WS_MAEMO_5
    QtMobility::QProximitySensor *sensor;
#endif

    void setLocation();
    void setIcons();

public:
    explicit Widget(QWidget *parent = 0);
    ~Widget();

private:
    QDesktopWidget *desktop;
    QTimer *mediaplayerTimer;
#ifdef Q_WS_MAEMO_5
    bool isProximityClosed();
    Maemo5DeviceEvents *deviceEvents;
    MafwRendererAdapter *renderer;
#endif

private slots:
    void openApplication();
    void onProximityChanged();
    void onTimerFinished();
    void connectSignals();
    void onMediaPlayerPressed();
    void enableButton1();
#ifdef Q_WS_MAEMO_5
    void startPoximityd();
    void stopProximityd();
    void onScreenLocked(bool);
    void onStateChanged(int);
#endif
};

#endif // WIDGET_H
