#include "widget.h"

Widget::Widget(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Widget)
{
    // Setting up the UI

    ui->setupUi(this);
    ui->mediaControls->hide();

    desktop = QApplication::desktop();
    //setLayout(ui->horizontalLayout);
    setWindowFlags(Qt::WindowStaysOnTopHint | Qt::FramelessWindowHint | Qt::X11BypassWindowManagerHint);
    setAttribute(Qt::WA_TranslucentBackground);
    if(QSettings().value("main/timeout").isNull())
        QSettings().setValue("main/timeout", 1200);
    mediaplayerTimer = new QTimer(this);
    mediaplayerTimer->setInterval(500);

    // Setting up the sensor
    // QtMobility's sensor API uses up 7-17% CPU time, even for a simple
    // label, this keeps the CPU @ 500MHz, not using it for maemo 5.

#ifndef Q_WS_MAEMO_5
    sensor = new QtMobility::QProximitySensor(this);
    sensor->connectToBackend();
    sensor->start();
#else
    deviceEvents = new Maemo5DeviceEvents(this);
    renderer = new MafwRendererAdapter();
    system("/sbin/start proximityd 2> /dev/null && sleep 2");
    this->connectSignals();;
    if(!deviceEvents->isScreenLocked())
        QTimer::singleShot(1000, this, SLOT(startPoximityd()));
#endif
    // Calling the initializing methods

    setIcons();
    setLocation();
    qDebug() << QApplication::applicationName() << QApplication::applicationVersion()
             << "initallized with process ID:" << QCoreApplication::applicationPid();
}

Widget::~Widget()
{
#ifdef Q_WS_MAEMO_5
    this->stopProximityd();
    system("/sbin/stop proximityd 2> /dev/null");
#endif
    delete ui;
}

void Widget::setLocation()
{
    int screenWidth, width;
    int screenHeight, height;
    int x, y;
    QSize windowSize;

    screenWidth = desktop->width();
    screenHeight = desktop->height();

    windowSize = size();
    width = windowSize.width();
    height = windowSize.height();

    x = (screenWidth - width);
    y = 0;

    move(x, y);
}

void Widget::setIcons()
{
    ui->button1->setIcon(QIcon("/usr/share/icons/hicolor/64x64/hildon/tasklaunch_media_player.png"));
    ui->button2->setIcon(QIcon("/usr/share/icons/hicolor/64x64/hildon/tasklaunch_photos.png"));
    ui->button3->setIcon(QIcon("/usr/share/icons/hicolor/64x64/hildon/general_email.png"));
    ui->button4->setIcon(QIcon("/usr/share/icons/hicolor/64x64/hildon/tasklaunch_sms_chat.png"));
    ui->button5->setIcon(QIcon("/usr/share/icons/hicolor/64x64/hildon/general_web.png"));
    ui->prevButton->setIcon(QIcon(prevButtonIcon));
    ui->nextButton->setIcon(QIcon(nextButtonIcon));
    ui->playButton->setIcon(QIcon(playButtonIcon));
}

void Widget::connectSignals()
{
#ifndef Q_WS_MAEMO_5
    connect(sensor, SIGNAL(readingChanged()), this, SLOT(onProximityChanged()));
#else
    connect(deviceEvents, SIGNAL(screenLocked(bool)), this, SLOT(onScreenLocked(bool)));
    connect(ui->prevButton, SIGNAL(clicked()), renderer, SLOT(previous()));
    connect(ui->nextButton, SIGNAL(clicked()), renderer, SLOT(next()));
    connect(ui->playButton, SIGNAL(clicked()), renderer, SLOT(resume()));
    connect(renderer, SIGNAL(stateChanged(int)), this, SLOT(onStateChanged(int)));
    QDBusConnection::sessionBus().connect("",
                                          "/proximityd/signal/state",
                                          "proximityd.signal.state",
                                          "changed",
                                          this, SLOT(onProximityChanged()));
#endif
    connect(mediaplayerTimer, SIGNAL(timeout()), this, SLOT(onMediaPlayerPressed()));
    connect(ui->button1, SIGNAL(pressed()), mediaplayerTimer, SLOT(start()));
}

void Widget::openApplication()
{
    QString appname;
    QObject *obj = QObject::sender();
    if (obj == ui->button1)
        appname = QString("mediaplayer");
    else if (obj == ui->button2)
        appname = QString("image-viewer");
    else if (obj == ui->button3)
        appname = QString("modest");
    else if (obj == ui->button4)
        appname = QString("rtcom-messaging-ui");
    else if (obj == ui->button5)
        appname = QString("browser");

    // dbus-send --type=method_call --dest=com.nokia.HildonDesktop.AppMgr
    // /com/nokia/HildonDesktop/AppMgr
    // com.nokia.HildonDesktop.AppMgr.LaunchApplication string:"$appname"

    QDBusInterface appLaunch("com.nokia.HildonDesktop.AppMgr",
                             "/com/nokia/HildonDesktop/AppMgr",
                             "com.nokia.HildonDesktop.AppMgr",
                             QDBusConnection::sessionBus(),
                             this);

    appLaunch.call("LaunchApplication", appname);
    if(ui->mediaControls->isVisible())
        ui->mediaControls->hide();
    this->hide();
}

void Widget::onProximityChanged()
{
#ifndef Q_WS_MAEMO_5
    if (sensor->reading()->close())
#else
    if(this->isProximityClosed())
#endif
    {
        int timeout = QSettings().value("main/timeout").toInt();
        QTimer::singleShot(timeout, this, SLOT(onTimerFinished()));
    }
}

void Widget::onTimerFinished()
{
#ifndef Q_WS_MAEMO_5
    if (sensor->reading()->close())
#else
    if(this->isProximityClosed())
#endif
    {
        if(!isVisible()) {
            this->setLocation();
            show();
            activateWindow();
        } else {
            if(ui->mediaControls->isVisible())
                ui->mediaControls->hide();
            this->hide();
        }
    }
}

#ifdef Q_WS_MAEMO_5
void Widget::startPoximityd()
{
    system(QString("dbus-send --dest=proximityd.method.change --type=method_call --print-reply /proximityd/method/change proximityd.method.change.Change string:turnOn int32:%2").arg(QCoreApplication::applicationPid()).toUtf8().constData());
}

void Widget::stopProximityd()
{
    system(QString("dbus-send --dest=proximityd.method.change --type=method_call --print-reply /proximityd/method/change proximityd.method.change.Change string:turnOff int32:%2").arg(QCoreApplication::applicationPid()).toUtf8().constData());
}

bool Widget::isProximityClosed()
{
    QFile proximitySys("/sys/devices/platform/gpio-switch/proximity/state");
    if(!proximitySys.exists())
        return false;
    else {
    proximitySys.open(QIODevice::ReadOnly);
    QTextStream s(&proximitySys);
    QString state = s.readLine();
    proximitySys.close();
    if(state == "closed")
        return true;
    else
        return false;
    }
}

void Widget::onScreenLocked(bool state)
{
    if(state)
        this->stopProximityd();
    else
        this->startPoximityd();
}

#endif

void Widget::onMediaPlayerPressed()
{
    if(ui->button1->isDown()) {
        if(!ui->mediaControls->isVisible())
            ui->mediaControls->show();
        else
            ui->mediaControls->hide();
        ui->button1->setDown(false);
        ui->button1->setEnabled(false);
        QTimer::singleShot(800, this, SLOT(enableButton1()));
    }
}

#ifdef Q_WS_MAEMO_5
void Widget::onStateChanged(int state)
{
  if(state == Paused)
  {
    ui->playButton->setIcon(QIcon(playButtonIcon));
    connect(ui->playButton, SIGNAL(clicked()), renderer, SLOT(pause()));
    connect(ui->playButton, SIGNAL(clicked()), renderer, SLOT(resume()));
  }
  else
  {
    ui->playButton->setIcon(QIcon(pauseButtonIcon));
    disconnect(ui->playButton, SIGNAL(clicked()), 0, 0);
    connect(ui->playButton, SIGNAL(clicked()), renderer, SLOT(pause()));
  }
}
#endif

void Widget::enableButton1()
{
    ui->button1->setEnabled(true);
}
