#ifndef WIDGET_H
#define WIDGET_H

#include <QtGui>
#include <QSettings>
#ifndef Q_WS_MAEMO_5
    #include <QProximitySensor>
#else
    #include <QtDBus>
    #include "maemo5deviceevents.h"
#endif

#include "ui_widget.h"

namespace Ui {
    class Widget;
}

class Widget : public QWidget
{
    Q_OBJECT
    Ui::Widget *ui;
#ifndef Q_WS_MAEMO_5
    QtMobility::QProximitySensor *sensor;
#endif

    void setLocation();
    void setIcons();

public:
    explicit Widget(QWidget *parent = 0);
    ~Widget();

private:
    QDesktopWidget *desktop;
#ifdef Q_WS_MAEMO_5
    bool isProximityClosed();
    Maemo5DeviceEvents *deviceEvents;
#endif

private slots:
    void openApplication();
    void onProximityChanged();
    void onTimerFinished();
    void connectSignals();
#ifdef Q_WS_MAEMO_5
    void startPoximityd();
    void stopProximityd();
    void onScreenLocked(bool);
#endif
};

#endif // WIDGET_H
