import QtQuick 1.0

Rectangle {
    id:root
    width: 800
    height: 400
    property string number
    color:"black"
    Component {
        id:numberDelegate
        Rectangle {
            width:105
            height:105
            color:(mouseArea.pressed) ? "lightgrey" : "grey"

            Text {
                anchors.centerIn: parent
                text:model.number
                color:"white"
                font.pixelSize: 60
            }
            MouseArea {
                id:mouseArea
                anchors.fill:parent
                onClicked: {
                    root.number+=model.number
                }
            }
        }
    }

    ListModel {
        id:numberModel
        ListElement { number:"1"}
        ListElement { number:"2"}
        ListElement { number:"3"}
        ListElement { number:"4"}
        ListElement { number:"5"}
        ListElement { number:"6"}
        ListElement { number:"7"}
        ListElement { number:"8"}
        ListElement { number:"9"}
        ListElement { number:"+"}
        ListElement { number:"0"}
        ListElement { number:"#"}
    }

    Text {
        anchors.left:row.left
        anchors.right:row.right
        anchors.bottom:row.top
        id:input
        wrapMode: Text.WrapAnywhere
        text:"01234567890p12341234#p1234#p1#" + root.number + "p1pp*"
        color:(root.number) ? "white" : "grey"
        font.pixelSize: 40
    }

    GridView {
        id: numberView
        anchors.top:parent.top
        anchors.right:parent.right
        width: 325
        height: 400
        cellHeight: 107
        cellWidth: 107
        interactive: false
        delegate: numberDelegate
        model: numberModel
    }

    Row {
        id:row
        anchors.left:parent.left
        anchors.bottom:parent.bottom
                Rectangle {
            width:356
            height:116
            color:(dialMouseArea.pressed) ? "lightgreen" : "green"
            Text {
                anchors.centerIn: parent
                text:"Dial"
                color:"white"
                font.pixelSize: 60
            }
            MouseArea {
                id:dialMouseArea
                anchors.fill: parent
                onClicked: {
                    if(root.number.length>0)
                    {
                        Qt.openUrlExternally("Tel:"+input.text)
                    }
                }
            }
        }
               Rectangle {
            width:116
            height:116
            color:(mouseArea.pressed) ? "red" : "grey"
            Text {
                anchors.centerIn: parent
                text:"<"
                color:"white"
                font.pixelSize: 60
            }
            MouseArea {
                id:mouseArea
                anchors.fill: parent
                onClicked: {
                    if(root.number.length>0)
                    {
                        root.number = root.number.substring(0,root.number.length-1)
                    }
                }
            }
        }
    }
}
