#ifndef ZBARDECODERTHREAD_H
#define ZBARDECODERTHREAD_H


#include <QObject>
#include <QThread>
#include <QWaitCondition>
#include <qmutex.h>
#include <zbar.h>

using namespace zbar;

class ZBarDecoderThread : public QThread
{
public:
    ZBarDecoderThread();
    ~ZBarDecoderThread();
    void run();
    char *thread_buffer;
    char *thread_output;
    const char *barcode_type;

    int frame_width;
    int frame_height;
    char frame_fourcc[5];
    int frame_bpp;
    bool isDecoding; // so the caller can see if we are running without blocking
    QMutex wait_mutex; // to allow the caller to block the thread when data is not available
    QWaitCondition thread_run; // as above
    bool hasFoundBarcode; // variable set if the decoder found something

private:
    int libzbar_analyse_image();
    bool doQuit; // to signal the thread to quit
    zbar_image_scanner_t *scanner;
    zbar_image_t *image;
};



#endif // ZBARDECODERTHREAD_H





