//Maemo Barcode Reader and Interpreter (mbarcode or maemo-barcode)
//Copyright (C) 2010 Simon Pickering
//Copyright (C) 2010 Svenn-Arne Dragly
//
//Some source code obtained from other individuals/companies (not affiliated with the project), such as
//Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
//
//Various parts of barcode recognition and GStreamer manipulation code written by:
//      Timothy Terriberry
//      Adam Harwell
//      Jonas Hurrelmann
//
//Original GStreamer code based on the maemo-examples package:
//Copyright (C) 2007-2008 Nokia Corporation. All rights reserved.
//Copyright (C) 2006 INdT.
//@author Talita Menezes <talita.menezes@indt.org.br>
//@author Cidorvan Leite <cidorvan.leite@indt.org.br>
//@author Jami Pekkanen <jami.pekkanen@nokia.com>
//
//This program is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef PLUGININTERFACES_H
#define PLUGININTERFACES_H

#include <QtCore>
#include <QtGui>
#include "sinkplugin.h"

class MainWindow;

// IMPORTANT: For some reason every virtual function must have a "= 0" for the function to be loaded
// If anyone knows why, please tell me (dragly)

// Sinks are plugins that represents information to the user
class PluginInterface {
public:
    virtual ~PluginInterface() {}

    // virtuals (all are optional to make sure the plugin still loads even if the developer made a mistake)
    virtual void initInterface(MainWindow *parent) {}; // an initialization function, always called after the plugin is loaded
    virtual QSet<SinkPlugin*> getSinkPlugins() {QSet<SinkPlugin*> empty; return empty;}; // a list of sink plugins provided by this plugin
    virtual QString getName() {return "Plugin name not defined!";}; // the name of the plugin
    virtual bool hasSettingsWindow() {return false;}; // set to true if the plugin has a settings window
    virtual QMainWindow* getSettingsWindow(QWidget *parent) {return new QMainWindow(parent);}; // a settings window for the plugin
};

// set up interfaces
Q_DECLARE_INTERFACE(PluginInterface,
                    "org.maemo.mbarcode.PluginInterface/0.1");
//Q_DECLARE_INTERFACE(ProviderInterface,
//                    "org.maemo.mbarcode.ProviderInterface/0.1");
#endif // PLUGININTERFACES_H
