#include "settingswindow.h"
#include "ui_settingswindow.h"
#include "mainwindow.h"
#include <QDebug>

SettingsWindow::SettingsWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::SettingsWindow)
{
    ui->setupUi(this);
}

SettingsWindow::~SettingsWindow()
{
    delete ui;
}
void SettingsWindow::setSettings(QSettings *settings) {
    this->settings = settings;
    qDebug() << "SettingsWindow::SettingsWindow(): Setting initial settings";
    ui->chkFullscreenScan->setChecked(settings->value("fullscreen_scan", false).toBool());
}

void SettingsWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void SettingsWindow::on_chkFullscreenScan_clicked()
{
    settings->setValue("fullscreen_scan", ui->chkFullscreenScan->isChecked());
}
