/**
 * maemo-barcode - barcode detection/recognition application
 *
 * Copyright (c) 2008 Simon Pickering <S.G.Pickering@bath.ac.uk>
 *
 * Various parts of barcode recognition and GStreamer manipulation code written by:
 *       Timothy Terriberry
 *       Adam Harwell
 *       Jonas Hurrelmann
 *
 * Original GStreamer code based on the maemo-examples package
 * Copyright (c) 2007-2008 Nokia Corporation. All rights reserved.
 * Copyright (c) 2006 INdT.
 * @author Talita Menezes <talita.menezes@indt.org.br>
 * @author Cidorvan Leite <cidorvan.leite@indt.org.br>
 * @author Jami Pekkanen <jami.pekkanen@nokia.com>
 */

#ifndef GUI_FREMANTLE_H
#define GUI_FREMANTLE_H

#include <gtk/gtk.h>
#include <hildon/hildon-banner.h>
#include <hildon/hildon-program.h>
//#include <sqlite3.h>

void initialize_gui(HildonProgram ** program, HildonWindow ** window, int *argc, char ***argv, gchar * app_name);
void destroy_gui(GtkWidget *window);

void orientation_init(void);
void orientation_enable_accelerators(void);
void orientation_disable_accelerators(void);



GtkWidget *create_search_window();
void search_dialog();

GtkWidget *create_scan_window();
void update_scan_window();
void scan_button_pressed( GtkWidget *button);
void open_button_pressed(GtkWidget *button);
void openfile_cb (GtkDialog *dialog, gint response, gpointer user_data);

void save_button_pressed( GtkWidget *button);

GtkWidget *create_lists_window();
void create_new_list_button();
void rename_list_button();
void delete_list_button();

GtkWidget *create_data_window();
void edit_data_button();
void delete_data_button();

GtkWidget *create_info_window(char *EAN);

void webfill_all_data_button();
void update_scan_window();



#endif

