/**
 * maemo-barcode - barcode detection/recognition application
 *
 * Copyright (c) 2008 Simon Pickering <S.G.Pickering@bath.ac.uk>
 *
 * Various parts of barcode recognition and GStreamer manipulation code written by:
 *       Timothy Terriberry
 *       Adam Harwell
 *       Jonas Hurrelmann
 *
 * Original GStreamer code based on the maemo-examples package
 * Copyright (c) 2007-2008 Nokia Corporation. All rights reserved.
 * Copyright (c) 2006 INdT.
 * @author Talita Menezes <talita.menezes@indt.org.br>
 * @author Cidorvan Leite <cidorvan.leite@indt.org.br>
 * @author Jami Pekkanen <jami.pekkanen@nokia.com>
 */

#ifndef LISTS_H
#define LISTS_H

#include <gtk/gtk.h>
#include <hildon/hildon-banner.h>
#include <hildon/hildon-program.h>
#include <sqlite3.h>

#define    COL_KEY         0
#define    COL_EAN         1
#define    COL_ISBN        2
#define    COL_TITLE       3
#define    COL_AUTHOR      4
#define    COL_PRICE       5
#define    COL_PLACE       6
#define    COL_NUMBER      7
#define    COL_DATE        8
#define    COL_TABLE_KEY   9

//#define    COL_KEY       0
#define   COL_SQL_NAME     1
#define   COL_PRETTY_NAME  2


GtkTreeModel *create_and_fill_lists_model();
GtkWidget *create_lists_view_and_model ();

GtkTreeModel *create_and_fill_data_model (char *sql_table_name);
GtkWidget *create_data_view_and_model (char *sql_table_name);

GtkTreeModel *create_and_fill_search_model(char *sql_table_name);
GtkWidget *create_search_view();

sqlite3* init_db();
void close_db();

int get_lists_row(sqlite3_stmt *stmt, int *key, char *sqlite_name, char *pretty_name);

int get_key_for_table(char *sqlite_name);
int get_table_from_key(int key, char *sqlite_name);

int get_next_data_row(sqlite3_stmt *stmt, int *key, char *EAN, char *ISBN, char *title, char *author, float *price, char *place, float *number, unsigned int *datetime);
int get_data_row(char *sql_name, int *key, char *EAN, char *ISBN, char *title, char *author, float *price, char *place, float *number, unsigned int *datetime);

void get_first_data_table(int *key, char *sqlite_name, char *pretty_name);

void get_pretty_from_sql_name(char *sqlite_name, char *pretty_name);
void get_sql_from_pretty_name(char *pretty_name, char *sqlite_name);

int add_list(char *pretty_list_name, char *sql_list_name);
void remove_list(char *sql_list_name);
void rename_list(char *sql_list_name, char *pretty_list_name);

void add_entry(char *sql_list_name, char *EAN, char *ISBN, char *title, char *author, float *price, char *place, float *number, unsigned int *datetime);
void remove_entry(char *sql_list_name, int key);
void change_entry(char *sql_list_name, int key, char *UPC, char *ISBN, char *title, char *author, float *price, char *place, float *number, unsigned int *datetime);

int deprettify_name(char* pretty_name, char* sql_name);

void submit_search(sqlite3_stmt *stmt, char* sql_name, int key, char *UPC, char *ISBN, char *title, char *author, float price, char *place, float number, unsigned int datetime);

//int test_db_is_ok();
void  on_list_view_changed(GtkWidget *widget);
void  on_data_view_changed(GtkWidget *widget);
void refill_data_model (char *sql_table_name);
char *GetCurrentListViewTable();
char *GetCurrentDataViewItem();

#endif

