/**
 * maemo-barcode - barcode detection/recognition application
 *
 * Copyright (c) 2008 Simon Pickering <S.G.Pickering@bath.ac.uk>
 *
 * Various parts of barcode recognition and GStreamer manipulation code written by:
 *       Timothy Terriberry
 *       Adam Harwell
 *       Jonas Hurrelmann
 *
 * Original GStreamer code based on the maemo-examples package
 * Copyright (c) 2007-2008 Nokia Corporation. All rights reserved.
 * Copyright (c) 2006 INdT.
 * @author Talita Menezes <talita.menezes@indt.org.br>
 * @author Cidorvan Leite <cidorvan.leite@indt.org.br>
 * @author Jami Pekkanen <jami.pekkanen@nokia.com>
 */

#include <conic.h>
#include "common.h"

#ifndef WEB_H
#define WEB_H
// we'll start with these ones first. Books are easy enough to tell apart (ISBN), not sure about the others.

#define EAN_TYPE_BOOK     0
#define EAN_TYPE_DVD      1
#define EAN_TYPE_CD       2
#define EAN_TYPE_OTHER    3

int GetConnected(void (*call_fn)(char*), gpointer user_data);

void connection_handler(ConIcConnection *connection, ConIcConnectionEvent *event, gpointer user_data);

//int lookup_data(char *EAN, char *ISBN, char *title, char *author, float *price, char *place, float *number, unsigned int *datetime);
//int query_upcdatabase_com(char *EAN, char *ISBN, char *title, char *author, float *price, char *place, float *number, unsigned int *datetime);
//int lookup_isbn(char *ISBN, char *title, char *author, float *price, char *place, float *number, unsigned int *datetime);


int GetEANtype(char *EAN, char *ISBN);
int LookupEAN(char *EAN);
int ean2isbn(char ean_str[14], char *isbn10_str);

int decode_ean_addon_code(char *ean_addon_str[5]);
int decode_isbn_number(char *isbn10[11], char *isbn13[14], char *group_identifier, char *publisher, char *item);



int handle_barcode_data(BarcodeData *bcdata); //(char *data, int barcode_type);
int parse_mixed_barcode_data(char *data);
int parse_numeric_barcode_data(char *data);
int check_ISBN13_checksum(char *data);
int check_ISBN10_checksum(char *data);
int check_EAN13_checksum(char *data);
int check_EAN8_checksum(char *data);
int handle_ISBN13(char *data);
int handle_ISBN10(char *data);
int handle_EAN13(char *data);
int handle_EAN8(char *data);


void openGeneric(char *uri1, char *question);
void openGeneric_response_cb (GtkDialog *dialog, gint response, gpointer user_data);

void openTel(char *uri);
void openTel_response_cb (GtkDialog *dialog, gint response, gpointer user_data);
void openEmail(char *address);
void openEmail_response_cb (GtkDialog *dialog, gint response, gpointer user_data);



void openURL(char *open);
void openURL_response_cb (GtkDialog *dialog, gint response, gpointer user_data);

#ifdef N900
void addVCard(char *vcard);
void addVCard_response_cb (GtkDialog *dialog, gint response, gpointer user_data);
#endif /* N900 */
#endif
