/**
 * maemo-barcode - barcode detection/recognition application
 *
 * Copyright (c) 2008 Simon Pickering <S.G.Pickering@bath.ac.uk>
 *
 * Various parts of barcode recognition and GStreamer manipulation code written by:
 *       Timothy Terriberry
 *       Adam Harwell
 *       Jonas Hurrelmann
 *
 * Original GStreamer code based on the maemo-examples package
 * Copyright (c) 2007-2008 Nokia Corporation. All rights reserved.
 * Copyright (c) 2006 INdT.
 * @author Talita Menezes <talita.menezes@indt.org.br>
 * @author Cidorvan Leite <cidorvan.leite@indt.org.br>
 * @author Jami Pekkanen <jami.pekkanen@nokia.com>
 */

#ifndef COMMON_H
#define COMMON_H

#include <gtk/gtk.h>
#include <hildon/hildon-banner.h>
#include <hildon/hildon-program.h>
#include <sqlite3.h>
#include <gst/gst.h>
#include <gst/gstbin.h>
#include <gst/interfaces/xoverlay.h>

#ifdef USE_ZBAR
#include <zbar.h>
#endif

#ifdef N900
#include <libosso.h>
#endif

#define DEVICE_UNKNOWN  -1
#define DEVICE_770  0
#define DEVICE_N800  1
#define DEVICE_N810  2
#define DEVICE_N900  3

#define BARCODE_TYPE_NONE     0
#define BARCODE_TYPE_1D       1
#define BARCODE_TYPE_DMTX     2
#define BARCODE_TYPE_QRCODE   3
#define BARCODE_TYPE_PDF417   4

#define WIDTH  320
#define HEIGHT  240

#define N900_WIDTH  640
#define N900_HEIGHT  480

#define NO_OF_TABS   4

/* Define structure for variables that
 * are needed thruout the application */
typedef struct {
    HildonProgram *program;
    HildonWindow *window;

    GtkWidget *tab[NO_OF_TABS];
    GtkWidget *label[NO_OF_TABS];
    
#ifdef FREMANTLE
    GtkWidget *scan_window_vbox_left;
    GtkWidget *scan_window_vbox_right;
    GtkWidget *scan_window_table;
#endif    
    
    
#ifdef N900
    GstElement *camera_src;
    DBusConnection *con;
    osso_context_t *osso;
    gboolean isportrait;
    gboolean accelerometers;
#endif
    GstElement *pipeline;
    GtkWidget *screen;
    GtkWidget *testoutput;
    GtkWidget *slider;

    GtkWidget *EANlabel;
    GtkWidget *titlelabel;
    GtkWidget *authorlabel;
    GtkWidget *pricelabel;

    gchar EAN_text[255];
    gchar title_text[255];
    gchar author_text[255];
    gchar price_text[50];

    GtkWidget *notebook;

    guint buffer_cb_id;


    guint timer_id;
//  guint scan_timer_id;
    long long last_upc_value;

    int scan_in_progress; // see below
    GtkWidget *scan_button; // so we can change the text when it's enabled/disabled
    sqlite3* db; // the SQLite database
    GtkWidget *lists_view; // the treeview widget for the list of tables
    GtkWidget *data_view; // the treeview widget for the data table
    GtkWidget *search_view; // the treeview widget for the data table

    GtkWidget *lists_selection; 
    GtkWidget *data_selection; 
    GtkWidget *search_selection; 

    gchar current_data_table_name[255];

    GtkListStore  *lists_store;
    GtkListStore  *data_store;

    int device_type;
    int frame_width;
    int frame_height;
    
#ifdef USE_ZBAR    
    zbar_image_scanner_t *scanner;
    zbar_image_t *image;
    //char *image_buffer;
#endif
    
    
    
} AppData;


typedef struct {
    char *message_output;
    int message_type;
} BarcodeData;


#endif

