#include "qrsink.h"
#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/pluginaction.h>

#include <QtCore>
#include <QProcess>
#include <QtDBus>
#include <QDesktopServices>

//#include <QLibrary>

//#include <QVersitReader>
//#include <QVersitDocument>
//#include <QBuffer>
//#include <QContact>
//#include <QContactManager>


// wait for qt-mobility 1.1 + versit
#include <QVersitOrganizerImporter>
#include <QOrganizerItem>
#include <QOrganizerManager>
#include <QVersitReader>
#include <QVersitDocument>

#include "textwindow.h"

#include <hildon-mime.h>
#include <dbus/dbus.h>

#include <qlibrary.h>
#include <stdlib.h>
#include <qfile.h>
#include <qurl.h>

#include <QContactManager>

#include <QContactPhoneNumber>
#include <QContactName>

#include <QContactEmailAddress>
#include <QContactNote>
#include <QContactBirthday>
#include <QContactAddress>
#include <QContactUrl>
#include <QContactNickname>
#include <QContactOrganization>

#include <QMaemo5InformationBox>


using namespace QtMobility;

//#define QT_NO_KEYWORDS
//#include <libosso-abook/osso-abook-contact.h>
//#include <libosso-abook/osso-abook-util.h>

QrSink::QrSink(const PluginInterface *interface) : PluginAction(interface) {
    image = QImage(":/images/qrcode.png");
    image = image.scaledToHeight(48, Qt::SmoothTransformation);
}

QString QrSink::getText()
{
    return buttonText;
}

QImage QrSink::getImage() {
    return image;
}

QString QrSink::getInformativeText() {
    return barcodeInformativeText.left(60) + "...";
}

void QrSink::clickAction(QWidget *parentWindow) {
     //QDBusInterface *interface = new QDBusInterface("com.nokia.osso_browser","/com/nokia/osso_browser/request",
     //                                               "com.nokia.osso_browser");
     //interface->call("open_new_window",url);

    if(type==QrSink::vCard){
        addVCard(barcodeText); //openGeneric(barcodeText); //

    }else if(type==QrSink::iCal){
            //addiCal(barcodeText);

    }else if(type==QrSink::BizCard){
        addMECARD(barcodeText);

    }else if(type==QrSink::iModeMECARD){
        addMECARD(barcodeText);

    }else if(type==QrSink::Install){
        openInstallFile(barcodeText);

    }else if(type==QrSink::URL){
        // make sure our URL starts with http:// and ends at or before a space.
        // may need to adjust this if e.g. a URL:/URLTO: type format is used without the http://
        int url_start = barcodeText.indexOf("http://",0,Qt::CaseInsensitive);
        QString trimmed_text;
        if(url_start>0)
            trimmed_text = barcodeText.mid(url_start,-1);
        else
            trimmed_text = barcodeText;

        int url_end = trimmed_text.indexOf(" ",0,Qt::CaseInsensitive);
        if (url_end>0)
            trimmed_text = trimmed_text.mid(0,url_end-1);

        openBrowser(trimmed_text);

    }else if(type==QrSink::iMode){
    }else if(type==QrSink::Email){
        openGeneric(barcodeText);

    }else if(type==QrSink::PhoneNumber){
        openGeneric(barcodeText);

    }else if(type==QrSink::SMS){
        if(!barcodeText.contains("SMS://",Qt::CaseInsensitive)){
            // change the uri from SMS: / SMSTO: to SMS://
            QString t(barcodeText);
            if(barcodeText.contains("SMSTO:",Qt::CaseInsensitive)){
                t.replace("SMSTO:", "SMS:", Qt::CaseInsensitive);
            }
//            if(barcodeText.contains("SMS:",Qt::CaseInsensitive)){
//                t.replace("SMS:", "SMS://", Qt::CaseInsensitive);
//            }else
            openGeneric(t);
        }else
            openGeneric(barcodeText);

    }else if(type==QrSink::MMS){
        openGeneric(barcodeText);

    }else if(type==QrSink::Geo){
        // we don't do anything with this at the moment, so should it be removed?
        openGeo(barcodeText);

    }else if(type==QrSink::YouTube){
    }else if(type==QrSink::Ovi){
        openInstallFile(barcodeText);
    }else if(type==QrSink::Apt){
        openApt(barcodeText);
    }else if(type==QrSink::Unknown){
        // this is a catch all, as long as we are the last plugin that's tried that's fine
        // but wouldn't want to prevent some other plugin handling something we don't!

        TextWindow *win = new TextWindow(parentWindow, barcodeText);
        win->show();
    }


}

void QrSink::barcodeAnalysed(QString barcodeType, QString barcodeData) {
    qDebug(qPrintable("QR-Code plugin got: " + barcodeType + " " + barcodeData));
    if(barcodeType == "QR-Code" || barcodeType == "dmtx") {
        qDebug("That is a QR-code or datamatrix! Let's give the user something to click!");

        buttonText = ""; // reset the text

        // work out what sort of data the code contains here
        // it would be better to parse the data before we display our button, that way we could show the url, email, tel no, etc. on the button
        // something for the improved version... :)

        if (barcodeData.indexOf("BEGIN:VCARD",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::vCard;
            buttonText.append("Open vCard");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData; // todo, parse and add name of person here

        }else if (barcodeData.indexOf("BEGIN:V",0,Qt::CaseInsensitive)==0){ // catch all payload types and pass to Versit
            type=this->QrSink::iCal;
            buttonText.append("Open iCal");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData; // todo, parse and add name of person here

        }else if(barcodeData.indexOf("BIZCARD:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::BizCard;
            buttonText.append("Open BizCard - may work, fingers crossed");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData; // todo, parse and add name of person here

        }else if(barcodeData.indexOf("[install]",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::Install;
            buttonText.append("Install package - not working currently");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData; // todo, parse and add name of app here

        }else if(barcodeData.indexOf("URL:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::URL;
            buttonText.append("Open URL");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData;

        }else if(barcodeData.indexOf("URLTO:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::URL;
            buttonText.append("Open URL");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData;

        }else if(barcodeData.indexOf("http://",0,Qt::CaseInsensitive)==0 || barcodeData.indexOf("https://",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::URL;
            buttonText.append("Open URL");
            barcodeText=barcodeData; // need to find where the http:// occurs in the string and trim it!
            barcodeInformativeText = barcodeData;

        }else if(barcodeData.indexOf("CNTS:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::iMode;
            buttonText.append("Open iMode data - not working currently");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData;

        }else if(barcodeData.indexOf("MECARD:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::iModeMECARD;
            buttonText.append("Open iMode MECARD data");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData;

        }else if(barcodeData.indexOf("MATMSG:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::iMode;
            buttonText.append("Open iMode data - not working currently");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData;

        }else if(barcodeData.indexOf("MEBKM:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::iMode;
            buttonText.append("Open iMode data - not working currently");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData;

        }else if(barcodeData.indexOf("LAPL:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::iMode;
            buttonText.append("Open iMode data - not working currently");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData;

        }else if(barcodeData.indexOf("mailto:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::Email;
            buttonText.append("Send e-mail");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData;

        }else if(barcodeData.indexOf("tel:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::PhoneNumber;
            buttonText.append("Use phone number");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData;

        }else if(barcodeData.indexOf("sms:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::SMS;
            buttonText.append("Open SMS");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData;

        }else if(barcodeData.indexOf("smsto:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::SMS;
            buttonText.append("Open SMS");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData;

        }else if(barcodeData.indexOf("mms:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::MMS;
            buttonText.append("Open MMS - not working currently");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData;

        }else if(barcodeData.indexOf("mmsto:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::MMS;
            buttonText.append("Open MMS - not working currently");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData;

        }else if(barcodeData.indexOf("geo:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::Geo;
            buttonText.append("Open geo location");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData;

        }else if(barcodeData.indexOf("youtube:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::YouTube;
            buttonText.append("Open YouTube link - not working currently");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData;

        }else if(barcodeData.indexOf("ovi:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::Ovi;
            buttonText.append("Install from Ovi - not working currently");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData;

        }else if(barcodeData.indexOf("apt:",0,Qt::CaseInsensitive)==0) {
            type=this->QrSink::Apt;
            buttonText.append("Install package");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("install:",0,Qt::CaseInsensitive)==0) {
            type=this->QrSink::Install;
            buttonText.append("Install package");
            barcodeText=barcodeData;

        }else{
            type=this->QrSink::Unknown;
            buttonText.append("View text");
            barcodeText=barcodeData;
            barcodeInformativeText = barcodeData;
        }

        qDebug() << "QRSink: " << "QR code reader is ready";
        emit isReady();
    }
}



/*
 install:c:catalogue,names,with,comma,seps;p:package,names,with,comma,seps;d:



 */

void QrSink::openApt(QString data)
{
    if (data.indexOf("apt:") == 0) {
        /**
        * Is an APT URL - remove the scheme, which
        * usually leaves us with the package name.
        **/
        data.remove(0, 4);

        /* package name is in data - create a .install */

        // ToDo - Make this handle the full range of options listed here
        // https://wiki.ubuntu.com/AptUrl


        QDir d("/home/user/.mbarcode/temp/");
        if(!d.exists("/home/user/.mbarcode/temp/"))
        d.mkpath("/home/user/.mbarcode/temp/");

        //QFile installfile(QString("/home/user/.mbarcode/" + data + ".install"));
        QTemporaryFile installfile("/home/user/.mbarcode/temp/aptXXXXXX.install");
        if (installfile.open()) {

            QString tempCatDef;
            QTextStream tempCatDefStream(&tempCatDef);

            QTextStream out(&installfile);
            out << "[install]" << endl;

            QStringList catalogueNames;

            // split into sections separated by the & character
            // fields are:
            // packages=list of packages to be installed, semi-colon separated if required
            // catalogues=extras|extras-testing|extras-devel|community-ssu (semi-colon separated)
            // or install file info with fields comma separated i.e.
            // name,uri,dist,components

            QStringList items = data.split("&");
            foreach(QString item, items){
                if(item.indexOf("package")==0){
                    // this is the list of packages

                    // strip out any spaces to make sure our replace works correctly
                    item.replace(" ","");

                    // the install file requires package=, so remove the s if it's there
                    item.replace("packages=", "package = ");

                    out << item << endl; // write to the file

                }else if(item.indexOf("catalog")==0){ // should be catalogues, but we need to match any possibilities for robustness

                    // find the first =, this will be at the end of "catalogues =" (or whatever the user has actually written)
                    int index = item.indexOf("=",0);

                    // chop off the whole of the start section, we'll add it back ourselves later
                    item.remove(0,index);

                    // now split to see if we have multiple catalogues to add
                    QStringList catalogueItems = data.split(";");
                    foreach(QString catalogueItem, catalogueItems){
                        if(catalogueItem.indexOf("community-testing")==0){
                            catalogueNames << "community-testing";

                            tempCatDefStream << "name = community-testing" << endl;
                            tempCatDefStream << "uri = http://repository.maemo.org/community-testing" << endl;
                            tempCatDefStream << "dist = fremantle" << endl;
                            tempCatDefStream << "components = free non-free" << endl;
                            tempCatDefStream << endl;

                        }else if(catalogueItem.indexOf("extras-devel")==0){
                            catalogueNames << "extras-devel";

                            tempCatDefStream << "name = extras-devel" << endl;
                            tempCatDefStream << "uri = http://repository.maemo.org/extras-devel" << endl;
                            tempCatDefStream << "components = free non-free" << endl;
                            tempCatDefStream << endl;

                        }else if(catalogueItem.indexOf("extras-testing")==0){
                            catalogueNames << "extras-testing";

                            tempCatDefStream << "name = extras-testing" << endl;
                            tempCatDefStream << "uri = http://repository.maemo.org/extras-testing" << endl;
                            tempCatDefStream << "components = free non-free" << endl;
                            tempCatDefStream << endl;

                        }else if(catalogueItem.indexOf("extras")==0){
                            catalogueNames << "extras";

                            tempCatDefStream << "name = extras" << endl;
                            tempCatDefStream << "uri = http://repository.maemo.org/extras" << endl;
                            tempCatDefStream << "components = free non-free" << endl;
                            tempCatDefStream << endl;

                        }else{
                            // this must be information to add a new catalogue
                            // items will be comma separated
                            QStringList catalogueElements = catalogueItem.split(",");

                            // check the second element contains an url
                            if(catalogueElements.at(1).indexOf("http://")!=0)
                                continue;

                            // there should be 4 elements: name, uri, dist, components
                            if(catalogueElements.length()!=4)
                                continue;

                            // get rid of some whitespace if any present
                            QString catName = catalogueElements.at(0).simplified();
                            // remove other unwanted punctuation
                            catName.replace(QRegExp("[^A-Za-z0-9_-]+"),"");


                            catalogueNames << catName;
                            tempCatDefStream << "name =" << catName << endl;
                            tempCatDefStream << "uri = " << catalogueElements[1] << endl;
                            if(catalogueElements.at(2).length()>0)
                                tempCatDefStream << "dist = " << catalogueElements[2] << endl;
                            tempCatDefStream << "components = " << catalogueElements[3] << endl;
                            tempCatDefStream << endl;

                        }
                    }
                }
            }

            if(catalogueNames.length()>0){
                out << "catalogues = ";
                for(int i=0; i<catalogueNames.length(); i++){
                    out << catalogueNames.at(i);
                    if(i!=catalogueNames.length()-1)
                        out << "; ";
                }
                out << endl; // finish the line from above
                out << endl; // add a blank line

                // no need to flush a text stream pointing at a QString I take it...

                out << tempCatDef; // add the actual catalogue definitions which we saved earlier
            }
            out.flush();

            installfile.close();

            openGeneric(QString("/home/user/.mbarcode/" + data + ".install"));

            // this is done automatically
            //installfile.remove(); // now remove the install file
        }
    }
}


// uses GLib, need to convert to pure Qt
void QrSink::openInstallFile(QString data)
{
    if (data.indexOf("install:", Qt::CaseInsensitive) == 0) {

        QDir d("/home/user/.mbarcode/temp/");
        if(!d.exists("/home/user/.mbarcode/temp/"))
            d.mkpath("/home/user/.mbarcode/temp/");

        //QFile installfile(QString("/home/user/.mbarcode/" + data + ".install"));
        QTemporaryFile installfile("/home/user/.mbarcode/temp/aptXXXXXX.install");
        if (installfile.open()) {
            QTextStream out(&installfile);
            out << "[install]" << endl;

            data.remove(0, 8); // remove the "install:" part

            // split at semi-colons to generate a list of items for the file
            QStringList listItem = data.split(";",QString::SkipEmptyParts);

            foreach (const QString sItem, listItem) {
                // see if this item is a package installation, or a catalogue installation or catalogue definition

                if(sItem.indexOf("p:", Qt::CaseInsensitive)==0){
                    // this is a package or list of packages
                    out << "package = ";
                    QStringList sElements = sItem.split(",", QString::SkipEmptyParts);
                    foreach (const QString sElement, sElements) {
                        out << sElement << "; ";
                    }
                    out << endl;

                } else if (sItem.indexOf("c:", Qt::CaseInsensitive)==0){
                    // this is a catalogue or list of catalogues
                    out << "catalogues = ";
                    QStringList sElements = sItem.split(",", QString::SkipEmptyParts);
                    foreach (const QString sElement, sElements) {
                        out << sElement << "; ";
                    }
                    out << endl;

                } else if (sItem.indexOf("[", Qt::CaseInsensitive)==0){
                    // this is the start of a catalogue definition
                    QStringList sElements = sItem.split(",", QString::SkipEmptyParts);

                    // see if we have any of the presets here
                    if(sElements.length()==1){
                        // yes we probably do
                        if(sItem.indexOf("[extras]", Qt::CaseInsensitive)) {
                            // add all the normal extras stuff in here

                            out << "[extras]" << endl;
                            out << "name = Maemo Extras" << endl;
                            out << "uri = http://repository.maemo.org/extras/" << endl;
                            out << "components = free non-free" << endl;


                        } else if(sItem.indexOf("[extras-testing]", Qt::CaseInsensitive)) {
                            // add all the normal extras-testing stuff in here

                            out << "[extras-testing]" << endl;
                            out << "name = Maemo Extras-testing" << endl;
                            out << "uri = http://repository.maemo.org/extras-testing/" << endl;
                            out << "components = free non-free" << endl;


                        } else if(sItem.indexOf("[extras-devel]", Qt::CaseInsensitive)) {
                            // add all the normal extras-devel stuff in here

                            out << "[extras-devel]" << endl;
                            out << "name = Maemo Extras-devel" << endl;
                            out << "uri = http://repository.maemo.org/extras-devel/" << endl;
                            out << "components = free non-free" << endl;

                        } else if(sItem.indexOf("[community-testing]", Qt::CaseInsensitive)) {
                            // add all the normal community-testing stuff in here

                            out << "[community-testing]" << endl;
                            out << "name = Maemo Community-testing" << endl;
                            out << "uri = http://repository.maemo.org/community-testing/" << endl;
                            out << "components = free non-free" << endl;

                        }

                    } else {
                        // must be a custom repo

                        foreach (QString sElement, sElements) {
                            if(sElement.indexOf("[") && sElement.indexOf("]"))
                                out << sElement << endl;
                            else if (sElement.indexOf("n:")) // this is the repo name
                                out << "name = " << sElement.remove(0,2) << endl;
                            else if (sElement.indexOf("u:")) // this is the repo uri
                                out << "uri = " << sElement.remove(0,2) << endl;
                            else if (sElement.indexOf("c:")) // this is the repo components list
                                out << "components = " << sElement.remove(0,2) << endl;
                            else // no idea, so just add it in raw form :)
                                out << sElement << endl;
                        }
                    }
                }



            }

            out.flush();
            installfile.close();
            openGeneric(installfile.fileName());
        }


            /*/* XXX: Extras is hardcoded for now...
            out << "catalogues = extras" << endl;
            out << "package = " << data << endl;*/


            // this is done automatically
            //installfile.remove(); // now remove the install file

    }
//    FILE *install_file;
//    gchar *data = g_strdup(data1);
//    char *filename=NULL;
//    char *p, *pp, *s, *e;
//
//    FILE *fid;
//
//    fid = fopen("/home/user/mbarcode.debug", "w+");
//    fprintf(fid,"Start\n");
//    fflush(fid);
//
//    // decide on a file name for our install file
//
//    // first see if this is an install file for a package or for a repo only
//    p = strstr(data, "package"); // see if we find the keyword "package"
//    if(p){
//        fprintf(fid,"First loop found text\n");
//        fflush(fid);
//        p = strstr(p, "="); // if so, look for the "="
//        if(p){
//            p++; // skip past the =
//            // find the end of the line, so we can work out the name (it might have spaces)
//            s = strstr(p,"\r");
//            if(!s)
//                s = strstr(p,"\n");
//
//            if(!s)
//                pp = g_strdup(p); // no line breaks found apparently
//            else
//                pp = g_strndup(p, (int)(s-p+1)); // so we don't get the line breaks
//
//
//            // assume we've now found the package name between p and the end of the string
//            // get rid of white space on both ends
//            fprintf(fid,"First loop about to strip\n");
//            fflush(fid);
//            pp = g_strstrip(pp);
//
//            fprintf(fid,"First loop about to remove spaces\n");
//            fflush(fid);
//            // remove any spaces in the name
//            e = strstr(pp," ");
//            while(e){
//                e[0] = '_';
//                e = strstr(pp," ");
//            }
//
//            fprintf(fid,"First loop generating filename: %s\n", pp);
//            fflush(fid);
//            //filename = g_strdup_printf("%s/%s.install", getenv ("MYDOCSDIR"), pp); // assuming the env var exists here, no checks made
//            filename = g_strdup_printf("/home/user/MyDocs/%s.install", pp);
//            g_free(pp);
//
//        }else{ // something wrong here
//            fprintf(fid,"First loop no =\n");
//            fflush(fid);
//        }
//
//    }
//
//
//    fprintf(fid,"Left first loop\n");
//    fflush(fid);
//
//    if(!filename){
//        // it might just have been a repo, so try to extract this name now
//        p = strstr(s, "repo_name"); // see if we find the keyword "package"
//        if(p){
//            fprintf(fid,"Second loop found text\n");
//            fflush(fid);
//            p = strstr(p, "="); // if so, look for the "="
//            if(p){
//                p++; // skip past the =
//                // find the end of the line, so we can work out the name (it might have spaces)
//                s = strstr(p,"\r");
//                if(!s)
//                    s = strstr(p,"\n");
//
//                if(!s)
//                    pp = g_strdup(p); // no line breaks found apparently
//                else
//                    pp = g_strndup(p, (int)(s-p+1)); // so we don't get the line breaks
//
//                // assume we've now found the package name between p and the end of the string
//                // get rid of white space on both ends
//                fprintf(fid,"First loop about to strip\n");
//                fflush(fid);
//                pp = g_strstrip(pp);
//
//                // remove any spaces in the name
//                fprintf(fid,"Second loop about to remove spaces\n");
//                fflush(fid);
//                e = strstr(pp," ");
//                while(e){
//                    e[0] = '_';
//                    e = strstr(pp," ");
//                }
//
//                fprintf(fid,"Second loop generating filename: %s\n", pp);
//                fflush(fid);
//                //filename = g_strdup_printf("%s/%s.install", getenv ("MYDOCSDIR"), pp); // assuming the env var exists here, no checks made
//                filename = g_strdup_printf("/home/user/MyDocs/%s.install", pp);
//                g_free(pp);
//
//            }else{ // something wrong here
//                fprintf(fid,"Second loop no =\n");
//                fflush(fid);
//
//            }
//        }
//    }
//
//    fprintf(fid,"Left second loop\n");
//    fflush(fid);
//
//
//    if(!filename){
//        // we'll just have to generate a filename now it seems
//        //filename = g_strdup_printf("%s//%s.install", getenv ("MYDOCSDIR"), tmpnam(NULL));
//        filename = g_strdup_printf("/home/user/MyDocs/%s.install", tmpnam(NULL));
//        fflush(fid);
//        fprintf(fid,"Generating random filename\n");
//    }
//
//    /*
//    // see if it already exists
//    install_file = fopen(filename, "r");
//    if(install_file){
//        // it already exists!
//        fclose(install_file);
//    }
//    */
//
//
//    if((install_file = fopen(filename, "w+")) == NULL){
//        fprintf(fid,"Failed to open filename\n");
//        fflush(fid);
//        g_free(filename);
//        g_free(data);
//        return; // and give up, for want of a better way of recovering...
//    }
//
//    fprintf(fid,"Writing data\n");
//    fflush(fid);
//
//    fwrite(data, 1, strlen(data), install_file);
//    fclose(install_file);
//
//    fprintf(fid,"about to openGeneric()\n");
//    fflush(fid);
//
//    openGeneric(filename, "Open install file: %s?");
//
//    fclose(fid);
//    g_free(filename);
//    g_free(data);

}

// http://geosms.wordpress.com/the-geosms-standard/
void QrSink::openGeo(QString data)
{
    double lat,lon;
    unsigned int somenumber=0;
    qDebug() << "In openGeo()";

    // parse the data
    if(data.contains("geo:", Qt::CaseInsensitive)){
        int offset = data.indexOf("geo:",0,Qt::CaseInsensitive);
        QString geo = data.right(data.length()-offset-4); // also chop off the geo:
        QStringList geoparts = geo.split(QRegExp("[,;]"));

        // first one should be lat, second lon
        QString temp = geoparts.at(0);
        lat = temp.toDouble();

        temp = geoparts.at(1);
        lon = temp.toDouble();

        // the latter parts hold optional altitude, accuracy and coordinate reference scheme data too
        // but we don't use this atm

        //
        // DBus call thanks to chem|st @ #maemo
        //
        QDBusInterface *interface = new QDBusInterface("com.nokia.Navigation.NokiaMapsProvider","/Provider","com.nokia.Navigation.MapProvider");
        interface->call("ShowPlaceGeo",lat,lon,somenumber);

        qDebug() << "Just trying to get Maps to open " << lat << "," << lon;

    }else{
        return;
    }



}



void QrSink::openGeneric(QString uri)
{

    qDebug() << "In openGeneric()";

    //GError *error; // see if we can get away with this...
    ////HildonURIAction* action = hildon_uri_get_default_action_by_uri((const gchar*)uri.constData(), &error);
    ////hildon_uri_open((const gchar*)uri.constData(), action, &error);

    qDebug() << "openGeneric(): Trying to handle: " << uri.toAscii();

    //hildon_uri_open((const gchar*)uri.constData(), NULL, NULL);

    ////hildon_uri_open ((const gchar*)uri.constData(), HILDON_URI_ACTION_NORMAL, &error);

    QFileInfo file(uri);
    if (file.exists()){
        // we're a file!
        qDebug() << "We're a file, using hildon_mime_open_file()";
        DBusConnection* conn;
        conn = dbus_bus_get(DBUS_BUS_SESSION, 0);
        hildon_mime_open_file(conn, QUrl::fromLocalFile(file.absoluteFilePath()).toEncoded().constData());
    }else{
        // we're something else.... see if this will work then :(
        qDebug() << "We're NOT a file, using QDesktopServices::openUrl()";
        QDesktopServices::openUrl(QUrl(uri, QUrl::TolerantMode));
    }



    //






//    QUrl url(uri, QUrl::TolerantMode);
//    struct DBusConnection;
//    typedef DBusConnection *(*Ptr_get_raw_handler_from_session_bus)();
//    static Ptr_get_raw_handler_from_session_bus get_raw_handler_from_session_bus = 0;
//    typedef void (*Ptr_hildon_mime_open)(DBusConnection *, const char *);
//    static Ptr_hildon_mime_open hildon_mime_open = 0;
//    typedef bool (*Ptr_hildon_uri_open)(const char *, void *, void **);
//    static Ptr_hildon_uri_open hildon_uri_open = 0;
//
//    if (!get_raw_handler_from_session_bus) {
//            get_raw_handler_from_session_bus = (Ptr_get_raw_handler_from_session_bus)QLibrary::resolve(QLatin1String("libQtDBus"), 4, "get_raw_handler_from_session_bus");
//        }
//
//        DBusConnection* conn = 0;
//        if (get_raw_handler_from_session_bus){
//            conn = get_raw_handler_from_session_bus();
//            if(!conn)
//                qDebug()<<"error in getting dbus connection";
//        }
//        if (!hildon_mime_open && !hildon_uri_open) {
//            QLibrary lib(QLatin1String("libhildonmime"), 0, 0);
//            hildon_mime_open = (Ptr_hildon_mime_open)lib.resolve("hildon_mime_open_file");
//            hildon_uri_open = (Ptr_hildon_uri_open)lib.resolve("hildon_uri_open");
//        }
//        QByteArray array = url.toEncoded();
//        if(array.startsWith("file://")) {
//            if (hildon_mime_open)
//                hildon_mime_open(conn, array.constData());
//            else
//                qDebug()<<"error in hildon_mime_open_file";
//        } else {
//
//            if (hildon_uri_open)
//                hildon_uri_open(array.constData(), 0, 0);
//            else
//                qDebug()<<"error in hildon_open_uri";
//
//        }





//    typedef bool (*Ptr_hildon_uri_open)(const char *, void *, void **);
//    static Ptr_hildon_uri_open hildon_uri_open = 0;
//
//    if (!hildon_uri_open) {
//        QLibrary lib(QLatin1String("libhildonmime"), 0, 0);
//    hildon_uri_open = (Ptr_hildon_uri_open)lib.resolve("hildon_uri_open");
//    }
//    if (hildon_uri_open)
//        hildon_uri_open((const char*)uri.constData(), 0, 0);



//#ifdef Q_WS_MAEMO_5 // Uses native file opening method
//            //TODO: find better solution for this, maybe get fixed in Qt
//            DBusConnection* conn;
//            QFile file(uri);
//            conn = dbus_bus_get(DBUS_BUS_SESSION, 0);
//            hildon_mime_open_file(conn, QUrl::fromLocalFile(file.absoluteFilePath()).toEncoded().constData());
//#else
//            /*
//            Not working with maemo5.
//            Uses hildon_uri_open function from
//            libhildonmime which should work,
//            but all files opened in browser.
//            */
//            QDesktopServices::openUrl(QUrl::fromLocalFile(file.absoluteFilePath()));
//#endif
}

void QrSink::openBrowser(QString uri)
{
    //action = hildon_uri_get_default_action_by_uri(uri, &error);
    //hildon_uri_open(uri, action, &error); //hildon_uri_open (uri, HILDON_URI_ACTION_NORMAL, error);
    //QDesktopServices::openUrl(uri);

    // DBus is currently the only way that does not open a new browser when we want to open a new window...
    QDBusInterface *interface = new QDBusInterface("com.nokia.osso_browser","/com/nokia/osso_browser/request","com.nokia.osso_browser");
    interface->call("open_new_window",uri);
}


// this uses GLib stuff, I suppose we should try to convert it to use Qt completely.....
void QrSink::addVCard(QString user_data)
{
    QDir d("/home/user/.mbarcode/temp/");
    if(!d.exists("/home/user/.mbarcode/temp/"))
        d.mkpath("/home/user/.mbarcode/temp/");

    QTemporaryFile file("/home/user/.mbarcode/temp/qt_tempXXXXXX.vcf");
    file.open();
    file.write(user_data.toUtf8());
    file.close();

    file.setAutoRemove(false); // we'll do this at the end

    //openGeneric(QString("file://" + file.fileName()));
    openGeneric(file.fileName());


    /*
    // this code might actually work now, but best wait for qt-mobility 1.1 + versit
    QVersitReader reader;
    QBuffer b(user_data.toAscii(), this);
    b.open(QBuffer::ReadOnly);
    reader.setDevice(&b);
    reader.startReading();
    reader.waitForFinished();
    QList<QVersitDocument> inputDocuments = reader.results();

    QVersitContactImporter importer;
     if (!importer.importDocuments(inputDocuments))
         return;
     QList<QContact> contacts = importer.contacts();
     // Note that the QContacts are not saved yet.
     // Use QContactManager::saveContacts() for saving if necessary
    QContactManager::saveContacts(contacts);
    */

}

void QrSink::addMECARD(QString user_data)
{

    // remove the MECARD: bit at the start
    if(user_data.indexOf("MECARD:",0,Qt::CaseInsensitive)==0){
        user_data = user_data.mid(7);
    } else if(user_data.indexOf("BIZCARD:",0,Qt::CaseInsensitive)==0){
        user_data = user_data.mid(8);
    }

    // find a contact manager
    QStringList availableManagers = QContactManager::availableManagers();
    QContactManager *manager;

    qDebug() << "Entered QrSink::addMECARD()";

    for(int managerIdx = 0; managerIdx < availableManagers.count(); managerIdx++) {
        manager = new QContactManager(availableManagers.at(managerIdx));

        if(manager) {
            //QList<QContactLocalId> contacts = manager->contacts();
            break;
        }
    }

    if(!manager) {
        qDebug() << "Failed to open a contact manager";
        return;
    }


    // create a new contact
    QContact newContact;

    // parse the string
    // ; record separators
    // : field name sep
    // ;; ends string

    QStringList records = user_data.split(";", QString::SkipEmptyParts);
    for(int recordIdx = 0; recordIdx < records.length(); recordIdx++) {
        QString currentRecord = records.at(recordIdx);

        qDebug() << "QrSink::addMECARD() current record=" << currentRecord;

        // see what this record encodes
        if(currentRecord.indexOf("N:",0,Qt::CaseSensitive)==0){
            // name
            QString nameString(currentRecord.mid(2)); // chop off the N:

            QContactName newContactName;

            if(nameString.contains(",")){
                // comma is used to separate first and last names
                QStringList nameItems = nameString.split(",");
                QString lastName = nameItems.at(0);
                QString firstName = nameItems.at(1);
                newContactName.setFirstName(firstName);
                newContactName.setLastName(lastName);
                qDebug() << "QrSink::addMECARD() found first/last names: " << firstName << " " << lastName;
            }else{
                // just a name, no first or last
                // so what should we do?
                newContactName.setLastName(nameString);
                qDebug() << "QrSink::addMECARD() found name: " << nameString;
            }
            if(newContact.saveDetail(&newContactName))
                qDebug() << "Saved name";
            else
                qDebug() << "Failed to save name";

        }else if(currentRecord.indexOf("SOUND:",0,Qt::CaseSensitive)==0){
            // no idea what this does
        }else if(currentRecord.indexOf("TEL:",0,Qt::CaseSensitive)==0){
            // telephone number

            QString phonenumberString(currentRecord.mid(4)); // chop off the TEL:
            QContactPhoneNumber newContactNumber;

            newContactNumber.setNumber(phonenumberString);
            // should be have a subtype here?

            qDebug() << "QrSink::addMECARD() found phone number: " << phonenumberString;
            if(newContact.saveDetail(&newContactNumber))
                qDebug() << "Saved phone number";
            else
                qDebug() << "Failed to save phone number";


        }else if(currentRecord.indexOf("TEL-AV:",0,Qt::CaseSensitive)==0){
            // videophone number
            QString phonenumberString(currentRecord.mid(7)); // chop off the TEL-AV:
            QContactPhoneNumber newContactNumber;

            newContactNumber.setNumber(phonenumberString);
            newContactNumber.setSubTypes(QContactPhoneNumber::SubTypeVideo);

            qDebug() << "QrSink::addMECARD() found video phone number: " << phonenumberString;
            if(newContact.saveDetail(&newContactNumber))
                qDebug() << "Saved video phone number";
            else
                qDebug() << "Failed to save video phone number";


        }else if(currentRecord.indexOf("EMAIL:",0,Qt::CaseSensitive)==0){
            // email address
            QString emailString(currentRecord.mid(6)); // chop off the EMAIL:
            QContactEmailAddress newEmail;

            newEmail.setEmailAddress(emailString);

            qDebug() << "QrSink::addMECARD() found email address: " << emailString;
            if(newContact.saveDetail(&newEmail))
                qDebug() << "Saved email";
            else
                qDebug() << "Failed to save email";



        }else if(currentRecord.indexOf("NOTE:",0,Qt::CaseSensitive)==0){
            // memo
            QString noteString(currentRecord.mid(5)); // chop off the NOTE:
            QContactNote newNote;

            newNote.setNote(noteString);
            qDebug() << "QrSink::addMECARD() found note: " << noteString;

            if(newContact.saveDetail(&newNote))
                qDebug() << "Saved note";
            else
                qDebug() << "Failed to save note";


        }else if(currentRecord.indexOf("BDAY:",0,Qt::CaseSensitive)==0){
            // birthday
            QString dateString(currentRecord.mid(5)); // chop off the BDAY:
            QString year;
            QString month;
            QString day;

            if (dateString.length()==6){
                year = dateString.mid(0,4);
                month = dateString.mid(4,2);
                day = dateString.mid(6,2);
            }else
                return;

            QDate bdayDate(year.toInt(), month.toInt(), day.toInt());
            QContactBirthday newBDay;

            newBDay.setDate(bdayDate);
            qDebug() << "QrSink::addMECARD() found birthday: " << bdayDate;

            if(newContact.saveDetail(&newBDay))
                qDebug() << "Saved birthday";
            else
                qDebug() << "Failed to save birthday";



        }else if(currentRecord.indexOf("ORG:",0,Qt::CaseSensitive)==0){
            QString orgString(currentRecord.mid(4)); // chop off the ORG:
            QContactOrganization newOrg;

            newOrg.setName(orgString);

            qDebug() << "QrSink::addMECARD() found organisation address: " << orgString;
            if(newContact.saveDetail(&newOrg))
                qDebug() << "Saved organisation";
            else
                qDebug() << "Failed to save organisation";


        }else if(currentRecord.indexOf("ADR:",0,Qt::CaseSensitive)==0){
            // address
            QString adrString(currentRecord.mid(4)); // chop off the ADR:
            QStringList adrItems = adrString.split(",");
            QContactAddress newAdr;

            if(adrItems.count()==0){
                qDebug() << "QrSink::addMECARD(): Unable to parse any address items";
                return;

            }else if (adrItems.count()==1){
                qDebug() << "QrSink::addMECARD(): Parsed 1 address item, assuming this is the street";
                newAdr.setStreet(adrItems.at(0));

            }else if (adrItems.count()==2){
                qDebug() << "QrSink::addMECARD(): Parsed 2 address items, assuming this is the street + town";
                newAdr.setStreet(adrItems.at(0));
                newAdr.setLocality(adrItems.at(1));

            }else if (adrItems.count()==3){
                qDebug() << "QrSink::addMECARD(): Parsed 3 address items, assuming this is the street, town, postcode";
                newAdr.setStreet(adrItems.at(0));
                newAdr.setLocality(adrItems.at(1));
                newAdr.setPostcode(adrItems.at(2));

            }else if (adrItems.count()==4){
                qDebug() << "QrSink::addMECARD(): Parsed 4 address items, assuming this is the street, town, region, postcode";
                newAdr.setStreet(adrItems.at(0));
                newAdr.setLocality(adrItems.at(1));
                newAdr.setRegion(adrItems.at(2));
                newAdr.setPostcode(adrItems.at(3));

            }else if (adrItems.count()==5){
                qDebug() << "QrSink::addMECARD(): Parsed 5 address items, assuming this is the street, town, region, postcode, country";
                newAdr.setStreet(adrItems.at(0));
                newAdr.setLocality(adrItems.at(1));
                newAdr.setRegion(adrItems.at(2));
                newAdr.setPostcode(adrItems.at(3));
                newAdr.setCountry(adrItems.at(4));

            }else if (adrItems.count()==6){
                qDebug() << "QrSink::addMECARD(): Parsed 6 address items, assuming these follow the MECARD standard";
                newAdr.setPostOfficeBox(adrItems.at(0)); // PO box
                newAdr.setStreet(adrItems.at(1) + QString(" ") + adrItems.at(2)); // room number + house number
                newAdr.setLocality(adrItems.at(3)); // city
                newAdr.setRegion(adrItems.at(4)); // prefecture
                newAdr.setPostcode(adrItems.at(5)); // zip code
                newAdr.setCountry(adrItems.at(6)); // country

            }else{
                qDebug() << "QrSink::addMECARD(): Parsed more than the standard 6 address items, using the first 6";
                newAdr.setPostOfficeBox(adrItems.at(0)); // PO box
                newAdr.setStreet(adrItems.at(1) + QString(" ") + adrItems.at(2)); // room number + house number
                newAdr.setLocality(adrItems.at(3)); // city
                newAdr.setRegion(adrItems.at(4)); // prefecture
                newAdr.setPostcode(adrItems.at(5)); // zip code
                newAdr.setCountry(adrItems.at(6)); // country

            }

            if(newContact.saveDetail(&newAdr))
                qDebug() << "Saved address";
            else
                qDebug() << "Failed to save address";



        }else if(currentRecord.indexOf("URL:",0,Qt::CaseSensitive)==0){
            // webpage
            QString urlString(currentRecord.mid(4)); // chop off the URL:
            QContactUrl newURL;

            newURL.setUrl(urlString);
            qDebug() << "QrSink::addMECARD() found url: " << urlString;

            if(newContact.saveDetail(&newURL))
                qDebug() << "Saved url";
            else
                qDebug() << "Failed to save url";


        }else if(currentRecord.indexOf("NICKNAME:",0,Qt::CaseSensitive)==0){
            // nickname
            QString nickString(currentRecord.mid(9)); // chop off the NICKNAME:
            QContactNickname newNick;

            newNick.setNickname(nickString);
            qDebug() << "QrSink::addMECARD() found nickname: " << nickString;

            if(newContact.saveDetail(&newNick))
                qDebug() << "Saved nickname";
            else
                qDebug() << "Failed to save nickname";


        }else{
            // unrecognised!
        }
    }


    // we should now see if the contact already exists and if so give the option to replace/merge/add

    // should we add a signal/slot pair so that plugins can signal their success/lack thereof to the ui and the user?

    // make the contact compatible
    newContact = manager->compatibleContact(newContact);


    /* Save the contact */
    if(manager->saveContact(&newContact)){
        //QMaemo5InformationBox::information (this->parent.parent, QString("Added MECARD"), 1000);
        qDebug() << "Added contact successfully";
    }else{
        //QMaemo5InformationBox::information (this->parent.parent, QString("Failed to add MECARD :("), 1000);
        qDebug() << "Could not add contact, error:" << manager->error();

    }

}




void QrSink::addiCal(QString user_data)
{
    //Q_UNUSED(user_data)

//    // wait for qt-mobility 1.1 + versit
//    #include <QVersitOrganizerImporter>
//    #include <QOrganizerItem>
//    #include <QOrganizerManager>

    QOrganizerManager *manager = new QOrganizerManager();

    QVersitReader reader;
    QByteArray ba(user_data.toAscii());
    QBuffer b(&ba, this);
    b.open(QBuffer::ReadOnly);
    reader.setDevice(&b);
    reader.startReading();
    reader.waitForFinished();

    QVersitOrganizerImporter importer;
    foreach (const QVersitDocument& document, reader.results()) {
        if (!importer.importDocument(document)) {
            qWarning() << "Import failed, " << importer.errorMap();
            continue;
        }
        QList<QOrganizerItem> items = importer.items();
        QList<QOrganizerItem>::iterator it = items.begin();
        while (it != items.end()) {
            *it = manager->compatibleItem(*it);
            it++;
        }
        manager->saveItems(&items);

    }




}




