#include "qrsink.h"
#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/sinkplugin.h>

#include <QtCore>
#include <QProcess>
#include <QtDBus>
#include <QDesktopServices>

//#include <QLibrary>

//#include <QVersitReader>
//#include <QVersitDocument>
//#include <QBuffer>
//#include <QContact>
//#include <QContactManager>

#include "textwindow.h"

#include <hildon-mime.h>

//#define QT_NO_KEYWORDS
//#include <libosso-abook/osso-abook-contact.h>
//#include <libosso-abook/osso-abook-util.h>

QrSink::QrSink(const PluginInterface *interface) : SinkPlugin(interface) {
    ready = false;
}

QString QrSink::getText()
{
    return buttonText;
}

void QrSink::clickAction(QWidget *parentWindow) {
     //QDBusInterface *interface = new QDBusInterface("com.nokia.osso_browser","/com/nokia/osso_browser/request",
     //                                               "com.nokia.osso_browser");
     //interface->call("open_new_window",url);

    if(type==QrSink::vCard){
        addVCard(barcodeText); //openGeneric(barcodeText); //

    }else if(type==QrSink::BizCard){

    }else if(type==QrSink::Install){
        openInstallFile(barcodeText);

    }else if(type==QrSink::URL){
        openBrowser(barcodeText);

    }else if(type==QrSink::iMode){
    }else if(type==QrSink::Email){
        openGeneric(barcodeText);

    }else if(type==QrSink::PhoneNumber){
        openGeneric(barcodeText);

    }else if(type==QrSink::SMS){
        if(!barcodeText.contains("SMS://",Qt::CaseInsensitive)){
            // change the uri from SMS: / SMSTO: to SMS://
            QString t(barcodeText);
            if(barcodeText.contains("SMS:",Qt::CaseInsensitive)){
                t.replace("SMS:", "SMS://", Qt::CaseInsensitive);
            }else if(barcodeText.contains("SMSTO:",Qt::CaseInsensitive)){
                t.replace("SMSTO:", "SMS://", Qt::CaseInsensitive);
            }
            openGeneric(t);
        }else
            openGeneric(barcodeText);

    }else if(type==QrSink::MMS){
        openGeneric(barcodeText);

    }else if(type==QrSink::Geo){
        // we don't do anything with this at the moment, so should it be removed?

    }else if(type==QrSink::YouTube){
    }else if(type==QrSink::Ovi){
        openInstallFile(barcodeText);

    }else if(type==QrSink::Unknown){
        // this is a catch all, as long as we are the last plugin that's tried that's fine
        // but wouldn't want to prevent some other plugin handling something we don't!

        TextWindow *win = new TextWindow(parentWindow, barcodeText);
        win->show();
    }


}

void QrSink::barcodeAnalysed(QString barcodeType, QString barcodeData) {
    qDebug(qPrintable("QR-Code plugin got: " + barcodeType + " " + barcodeData));
    if(barcodeType == "QR-Code" || barcodeType == "dmtx") {
        qDebug("That is a QR-code or datamatrix! Let's give the user something to click!");

        buttonText = ""; // reset the text

        // work out what sort of data the code contains here
        // it would be better to parse the data before we display our button, that way we could show the url, email, tel no, etc. on the button
        // something for the improved version... :)

        if (barcodeData.indexOf("BEGIN:VCARD",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::vCard;
            buttonText.append("Open vCard");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("BIZCARD:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::BizCard;
            buttonText.append("Open BizCard");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("[install]",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::Install;
            buttonText.append("Install package");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("URL:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::URL;
            buttonText.append("Open URL");
            barcodeText=barcodeData;
        }else if(barcodeData.indexOf("URLTO:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::URL;
            buttonText.append("Open URL");
            barcodeText=barcodeData;
        }else if(barcodeData.indexOf("http://",0,Qt::CaseInsensitive)==0 || barcodeData.indexOf("https://",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::URL;
            buttonText.append("Open URL");
            barcodeText=barcodeData; // need to find where the http:// occurs in the string and trim it!

        }else if(barcodeData.indexOf("CNTS:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::iMode;
            buttonText.append("Open iMode data");
            barcodeText=barcodeData;
        }else if(barcodeData.indexOf("MECARD:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::iMode;
            buttonText.append("Open iMode data");
            barcodeText=barcodeData;
        }else if(barcodeData.indexOf("MATMSG:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::iMode;
            buttonText.append("Open iMode data");
            barcodeText=barcodeData;
        }else if(barcodeData.indexOf("MEBKM:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::iMode;
            buttonText.append("Open iMode data");
            barcodeText=barcodeData;
        }else if(barcodeData.indexOf("LAPL:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::iMode;
            buttonText.append("Open iMode data");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("mailto:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::Email;
            buttonText.append("Send e-mail");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("tel:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::PhoneNumber;
            buttonText.append("Use phone number");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("sms:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::SMS;
            buttonText.append("Open SMS");
            barcodeText=barcodeData;
        }else if(barcodeData.indexOf("smsto:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::SMS;
            buttonText.append("Open SMS");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("mms:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::MMS;
            buttonText.append("Open MMS");
            barcodeText=barcodeData;
        }else if(barcodeData.indexOf("mmsto:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::MMS;
            buttonText.append("Open MMS");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("geo:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::Geo;
            buttonText.append("Open geo location");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("youtube:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::YouTube;
            buttonText.append("Open YouTube link");
            barcodeText=barcodeData;

        }else if(barcodeData.indexOf("ovi:",0,Qt::CaseInsensitive)==0){
            type=this->QrSink::Ovi;
            buttonText.append("Install from Ovi");
            barcodeText=barcodeData;

        }else{
            type=this->QrSink::Unknown;
            buttonText.append("View text");
            barcodeText=barcodeData;
        }


        ready = true;
    } else {
        ready = false;
    }
}

bool QrSink::isReady() {
    return ready;
}





// uses GLib, need to convert to pure Qt
void QrSink::openInstallFile(QString data)
{
//    FILE *install_file;
//    gchar *data = g_strdup(data1);
//    char *filename=NULL;
//    char *p, *pp, *s, *e;
//
//    FILE *fid;
//
//    fid = fopen("/home/user/mbarcode.debug", "w+");
//    fprintf(fid,"Start\n");
//    fflush(fid);
//
//    // decide on a file name for our install file
//
//    // first see if this is an install file for a package or for a repo only
//    p = strstr(data, "package"); // see if we find the keyword "package"
//    if(p){
//        fprintf(fid,"First loop found text\n");
//        fflush(fid);
//        p = strstr(p, "="); // if so, look for the "="
//        if(p){
//            p++; // skip past the =
//            // find the end of the line, so we can work out the name (it might have spaces)
//            s = strstr(p,"\r");
//            if(!s)
//                s = strstr(p,"\n");
//
//            if(!s)
//                pp = g_strdup(p); // no line breaks found apparently
//            else
//                pp = g_strndup(p, (int)(s-p+1)); // so we don't get the line breaks
//
//
//            // assume we've now found the package name between p and the end of the string
//            // get rid of white space on both ends
//            fprintf(fid,"First loop about to strip\n");
//            fflush(fid);
//            pp = g_strstrip(pp);
//
//            fprintf(fid,"First loop about to remove spaces\n");
//            fflush(fid);
//            // remove any spaces in the name
//            e = strstr(pp," ");
//            while(e){
//                e[0] = '_';
//                e = strstr(pp," ");
//            }
//
//            fprintf(fid,"First loop generating filename: %s\n", pp);
//            fflush(fid);
//            //filename = g_strdup_printf("%s/%s.install", getenv ("MYDOCSDIR"), pp); // assuming the env var exists here, no checks made
//            filename = g_strdup_printf("/home/user/MyDocs/%s.install", pp);
//            g_free(pp);
//
//        }else{ // something wrong here
//            fprintf(fid,"First loop no =\n");
//            fflush(fid);
//        }
//
//    }
//
//
//    fprintf(fid,"Left first loop\n");
//    fflush(fid);
//
//    if(!filename){
//        // it might just have been a repo, so try to extract this name now
//        p = strstr(s, "repo_name"); // see if we find the keyword "package"
//        if(p){
//            fprintf(fid,"Second loop found text\n");
//            fflush(fid);
//            p = strstr(p, "="); // if so, look for the "="
//            if(p){
//                p++; // skip past the =
//                // find the end of the line, so we can work out the name (it might have spaces)
//                s = strstr(p,"\r");
//                if(!s)
//                    s = strstr(p,"\n");
//
//                if(!s)
//                    pp = g_strdup(p); // no line breaks found apparently
//                else
//                    pp = g_strndup(p, (int)(s-p+1)); // so we don't get the line breaks
//
//                // assume we've now found the package name between p and the end of the string
//                // get rid of white space on both ends
//                fprintf(fid,"First loop about to strip\n");
//                fflush(fid);
//                pp = g_strstrip(pp);
//
//                // remove any spaces in the name
//                fprintf(fid,"Second loop about to remove spaces\n");
//                fflush(fid);
//                e = strstr(pp," ");
//                while(e){
//                    e[0] = '_';
//                    e = strstr(pp," ");
//                }
//
//                fprintf(fid,"Second loop generating filename: %s\n", pp);
//                fflush(fid);
//                //filename = g_strdup_printf("%s/%s.install", getenv ("MYDOCSDIR"), pp); // assuming the env var exists here, no checks made
//                filename = g_strdup_printf("/home/user/MyDocs/%s.install", pp);
//                g_free(pp);
//
//            }else{ // something wrong here
//                fprintf(fid,"Second loop no =\n");
//                fflush(fid);
//
//            }
//        }
//    }
//
//    fprintf(fid,"Left second loop\n");
//    fflush(fid);
//
//
//    if(!filename){
//        // we'll just have to generate a filename now it seems
//        //filename = g_strdup_printf("%s//%s.install", getenv ("MYDOCSDIR"), tmpnam(NULL));
//        filename = g_strdup_printf("/home/user/MyDocs/%s.install", tmpnam(NULL));
//        fflush(fid);
//        fprintf(fid,"Generating random filename\n");
//    }
//
//    /*
//    // see if it already exists
//    install_file = fopen(filename, "r");
//    if(install_file){
//        // it already exists!
//        fclose(install_file);
//    }
//    */
//
//
//    if((install_file = fopen(filename, "w+")) == NULL){
//        fprintf(fid,"Failed to open filename\n");
//        fflush(fid);
//        g_free(filename);
//        g_free(data);
//        return; // and give up, for want of a better way of recovering...
//    }
//
//    fprintf(fid,"Writing data\n");
//    fflush(fid);
//
//    fwrite(data, 1, strlen(data), install_file);
//    fclose(install_file);
//
//    fprintf(fid,"about to openGeneric()\n");
//    fflush(fid);
//
//    openGeneric(filename, "Open install file: %s?");
//
//    fclose(fid);
//    g_free(filename);
//    g_free(data);

}


void QrSink::openGeneric(QString uri)
{

    qDebug() << "In openGeneric()";

    GError *error; // see if we can get away with this...
    //HildonURIAction* action = hildon_uri_get_default_action_by_uri((const gchar*)uri.constData(), &error);
    //hildon_uri_open((const gchar*)uri.constData(), action, &error);

    qDebug() << "openGeneric(): Trying to handle: " << uri.toAscii();

    hildon_uri_open((const gchar*)uri.constData(), NULL, NULL);

    //hildon_uri_open ((const gchar*)uri.constData(), HILDON_URI_ACTION_NORMAL, &error);

    //QDesktopServices::openUrl(uri);

//#ifdef Q_WS_MAEMO_5 // Uses native file opening method
//            //TODO: find better solution for this, maybe get fixed in Qt
//            DBusConnection* conn;
//            QFile file(uri);
//            conn = dbus_bus_get(DBUS_BUS_SESSION, 0);
//            hildon_mime_open_file(conn, QUrl::fromLocalFile(file.absoluteFilePath()).toEncoded().constData());
//#else
//            /*
//            Not working with maemo5.
//            Uses hildon_uri_open function from
//            libhildonmime which should work,
//            but all files opened in browser.
//            */
//            QDesktopServices::openUrl(QUrl::fromLocalFile(file.absoluteFilePath()));
//#endif
}

void QrSink::openBrowser(QString uri)
{
    //action = hildon_uri_get_default_action_by_uri(uri, &error);
    //hildon_uri_open(uri, action, &error); //hildon_uri_open (uri, HILDON_URI_ACTION_NORMAL, error);
    //QDesktopServices::openUrl(uri);

    // DBus is currently the only way that does not open a new browser when we want to open a new window...
    QDBusInterface *interface = new QDBusInterface("com.nokia.osso_browser","/com/nokia/osso_browser/request","com.nokia.osso_browser");
    interface->call("open_new_window",uri);
}


// this uses GLib stuff, I suppose we should try to convert it to use Qt completely.....
void QrSink::addVCard(QString user_data)
{
    QDir d("/home/user/.mbarcode/temp/");
    if(!d.exists("/home/user/.mbarcode/temp/"))
        d.mkpath("/home/user/.mbarcode/temp/");

    QTemporaryFile file("/home/user/.mbarcode/temp/qt_tempXXXXXX.vcf");
    file.open();
    file.write(user_data.toAscii());
    file.close();

    file.setAutoRemove(false); // we'll do this at the end

    openGeneric(QString("file://" + file.fileName()));


    //file.~QTemporaryFile();


    /*QVersitReader reader;
    QBuffer b(user_data.toAscii(), this);
    b.open(QBuffer::ReadOnly);
    reader.setDevice(&b);

    reader.readAll();

    QVersitDocument inputDocument = reader.result().takeFirst();
    QVersitContactImporter importer;
    QContact contact = importer.importContact(inputDocument);

    QContactManager::saveContact(contact); */



//    g_type_init();
//    QLibrary *&lib = qgconf_libgconf;
//    qDebug() << "loading gconf";;
//    lib = new QLibrary(QLatin1String("gconf-2"));
//    triedToLoadLibrary = true;
//    if (lib->load() && lib->resolve("gconf_client_get_default")) {
//        qDebug() << "load successfull!";
//    } else {
//        qDebug() << "Load failed";
//        lib->unload();
//        delete lib;
//        lib = 0;
//        return;
//    }
//
//    char *vcard = (char*)user_data.constData();
//    OssoABookContact *contact;
//    GError *error = NULL;
//    EBook *book = NULL;
//    book = osso_abook_system_book_dup_singleton (TRUE, NULL);
//    g_return_val_if_fail (E_IS_BOOK (book), FALSE);
//
//    if (!vcard)
//        return;
//
//    contact = osso_abook_contact_new_from_vcard (NULL, vcard);
//    g_assert (OSSO_ABOOK_IS_CONTACT (contact));
//
//    if (!e_book_add_contact (book, E_CONTACT (contact), &error)) {
//            g_warning ("%s: %s", G_STRLOC, error->message);
//            g_assert_not_reached ();
//    }
//
//    lib->unload();
//    delete lib;
}


