#include <QtGui>

#include "isbn.h"

#include <QtDBus>

#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/sinkplugin.h>
#include <mbarcode-qt/mainwindow.h>

void ISBNPlugin::initInterface(MainWindow *parent)
{
    sink = new ISBNSink(this);
    QWidget* widget = parent;
    connect(widget, SIGNAL(barcodeAnalysedSignal(QString,QString)),
            sink, SLOT(barcodeAnalysed(QString,QString)));
}

QSet<SinkPlugin*> ISBNPlugin::getSinkPlugins()
{
    QSet<SinkPlugin*> newList;
    newList.insert(sink);
    return newList;
}

Q_EXPORT_PLUGIN2(mbqt_qrplugin, ISBNPlugin)


ISBNSink::ISBNSink(const PluginInterface *interface) : SinkPlugin(interface)
{
    ready = false;
}

QString ISBNSink::getText()
{
    return "Search Amazon for ISBN";
}

void ISBNSink::clickAction(QWidget * /*parentWindow*/)
{
    openBrowser(isbn);
}

void ISBNSink::barcodeAnalysed(QString barcodeType, QString barcodeData)
{
    qDebug(qPrintable("ISBN plugin got: " + barcodeType + "|" + barcodeData));
    if (barcodeType == "EAN-10" || barcodeType == "EAN-13")
    {
        if (barcodeData.length() == 13)
            barcodeData = convertISBN13to10(barcodeData);
        isbn = barcodeData;
        ready = true;
    }
}

bool ISBNSink::isReady()
{
    return ready;
}

void ISBNSink::openBrowser(QString isbn)
{
    QDBusInterface *interface = new QDBusInterface("com.nokia.osso_browser",
                "/com/nokia/osso_browser/request","com.nokia.osso_browser");
    QString amazonUrl = "http://www.amzn.com/" + isbn;
    qDebug(qPrintable("URL: " + amazonUrl));
    interface->call("open_new_window", amazonUrl);
}

QString ISBNSink::convertISBN13to10(QString isbn)
{
    if (isbn.length() != 13)
        return isbn;

    isbn = isbn.mid(3, 9);

    int checksum = 0;
    for (int i = 0; i < isbn.length(); i++)
        checksum += (isbn[i].toLatin1() - 48) * (10-i);

    checksum = 11 - (checksum % 11);
    if (checksum == 10)
        isbn += 'X';
    else if (checksum == 11)
        isbn += '0';
    else
        isbn += 48 + (char)checksum;
    return isbn;
}


