#ifndef CONFIGURATION_H
#define CONFIGURATION_H

/*
  MathJinni - A simple formular calculator
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <list>
#include <vector>

#include <Lum/Config/Config.h>

#include <Lum/Model/Number.h>

class Alternative
{
private:
  std::wstring name;
  std::wstring symbol;
  std::wstring from;
  std::wstring to;

public:
  Alternative(const std::wstring& name,
              const std::wstring& symbol,
              const std::wstring& from,
              const std::wstring& to);

  std::wstring GetName() const;
  std::wstring GetSymbol() const;
  std::wstring GetFrom() const;
  std::wstring GetTo() const;
};

class Unit
{
private:
  std::wstring              type;

  std::vector<Alternative*> alternatives;

public:
  Unit(const std::wstring& type);

  std::wstring GetType() const;
  size_t GetAlternativeCount() const;
  Alternative* GetAlternative(size_t index) const;

  void AddAlternative(Alternative* alternative);
};

class Variable
{
private:
  std::wstring name;
  std::wstring unit;
  std::wstring description;

public:
  Variable(const std::wstring& name,
           const std::wstring& unit,
           const std::wstring& description);

  std::wstring GetName() const;
  std::wstring GetDescription() const;
  std::wstring GetUnit() const;
};

class Formula
{
private:
  std::wstring           name;
  std::wstring           category;
  std::wstring           unit;
  std::wstring           formula;
  std::wstring           description;

  std::vector<Variable*> variables;

public:
  Formula(const std::wstring& name,
          const std::wstring& category,
          const std::wstring& unit,
          const std::wstring& formula,
          const std::wstring& description);

  std::wstring GetName() const;
  std::wstring GetCategory() const;
  std::wstring GetFormula() const;
  std::wstring GetDescription() const;
  std::wstring GetUnit() const;

  void AddVariable(Variable* variable);

 const std::vector<Variable*>& GetVariables() const;
};

extern std::vector<Unit*>    units;
extern std::vector<Formula*> formulas;

extern std::map<std::wstring,Unit*> unitMap;

// 0 = grad, 1 = rad
extern Lum::Model::ULongRef calcTrigoMode;

/**
  Interface for reading configuration
*/
class ConfigPlugin
{
public:
  virtual void LoadData() = 0;
  virtual void LoadConfig(Lum::Config::Node *top) = 0;
  virtual void StoreConfig(Lum::Config::Node *top) = 0;
};


extern bool LoadData(std::list<ConfigPlugin*>& plugins);

extern bool LoadConfig(std::list<ConfigPlugin*>& plugins);
extern bool SaveConfig(std::list<ConfigPlugin*>& plugins);

#endif
