#include "sudokutable.h"
#include <QPoint>
#include <QString>
/*
============================================================================
Name        : SudokuTable.cpp
Author      : Petri Kultanen
Version     :
Copyright   : Your copyright notice
Description : CSudokuTable implementation
============================================================================
*/
CSudokuTable::CSudokuTable()
{
                clearTable();
}

CSudokuTable::~CSudokuTable()
{
}
//Generate new game. this can take long time if aAmount is >53 if it is >56 this funcktion may newer return.
void CSudokuTable::newGame(int aAmount)
{
    clearTable();
    while(!isTableSolvableL())
    {
        generateFullTableL();
        removeNumbers(aAmount);

    }
}
//---------------------------------------------------------------------------
// Returns true if given number is in given row
bool CSudokuTable::isNumInRowL(int aNum,int aRow)
{
    if(aNum<1 || aRow<0 || aNum>9 || aRow>8) {emit error("100(isNumInRowL) ");return false;}
        for(int i=0;i<9;i++)
        {
                if(table[i][aRow]==aNum)
                {
                        return true;
                }
        }
        return false;
}
//---------------------------------------------------------------------------
// Returns true if given number is in given column
bool CSudokuTable::isNumInColL(int aNum,int aCol)
{
        if(aNum<1 || aCol<0 || aNum>9 || aCol>8) {emit error("101(isNumInColL) ");return false;}
        for(int i=0;i<9;i++)
        {
                if(table[aCol][i]==aNum)
                {
                        return true;
                }
        }
        return false;
}
//---------------------------------------------------------------------------
//Returns true if given number is in the same "3*3 Cell" that given coordinates
bool CSudokuTable::isNumInCellL(int aNum,int aCol,int aRow){

        if(aNum<1 || aCol<0 || aRow<0 || aNum>9 || aCol>8 || aRow>8) {emit error("102(isNumInCellL)");return false;}
        int cel=getCellL(aCol,aRow);
        int rStart=0;
        int cStart=0;

        if(cel==1) {cStart=0;rStart=0;}
        if(cel==2) {cStart=3;rStart=0;}
        if(cel==3) {cStart=6;rStart=0;}
        if(cel==4) {cStart=0;rStart=3;}
        if(cel==5) {cStart=3;rStart=3;}
        if(cel==6) {cStart=6;rStart=3;}
        if(cel==7) {cStart=0;rStart=6;}
        if(cel==8) {cStart=3;rStart=6;}
        if(cel==9) {cStart=6;rStart=6;}

        for(int row=rStart;row<rStart+3;row++)
        {
                for(int col=cStart;col<cStart+3;col++)
                {
                        if(table[col][row]==aNum)
                        {
                                return true;
                        }
                }
        }
        return false;
}
//---------------------------------------------------------------------------
//Returns true if given number is in same row, column or cell
bool CSudokuTable::isNumInAnyDirectionL(int aNum, int aCol, int aRow)
{
        if(aNum<1 || aCol<0 || aRow<0 || aNum>9 || aCol>8 || aRow>8) {emit error("103(isNumInAnyDirectionL)");return false;}

        if (isNumInCellL(aNum,aCol,aRow)) return true;
        if (isNumInRowL(aNum,aRow)) return true;
        if (isNumInColL(aNum,aCol)) return true;

        return false;
}
//---------------------------------------------------------------------------
//Returns number of cell, witch given cordinates points to
int CSudokuTable::getCellL(int aCol, int aRow){
        if(aCol<3 && aRow<3) return 1;
        if(aCol>2 && aCol<6 && aRow<3) return 2;
        if(aCol>5 && aCol<9 && aRow<3) return 3;
        if(aCol<3 && aRow>2 && aRow<6) return 4;
        if(aCol>2 && aCol<6 && aRow>2 && aRow<6) return 5;
        if(aCol>5 && aCol<9 && aRow>2 && aRow<6) return 6;
        if(aCol<3 && aRow>5 && aRow<9) return 7;
        if(aCol>2 && aCol<6 && aRow>5 && aRow<9) return 8;
        if(aCol>5 && aCol<9 && aRow>5 && aRow<9) return 9;

        {emit error("104(getCellL)");return 0;}
        return 0;
}
//---------------------------------------------------------------------------
//Clears the table
void CSudokuTable::clearTable(){
        for(int row=0;row<9;row++)
        {
                for(int col=0;col<9;col++)
                {
                        table[col][row]=0;
                        memoryTable[col][row]=0;
                }
        }
}
//---------------------------------------------------------------------------
//Clears given row
void CSudokuTable::clearRow(int aRow)
{
        for(int i=0;i<9;i++)
        {
                table[i][aRow]=0;
        }
}
//---------------------------------------------------------------------------
//Returns if number in given coordinates is zero
bool CSudokuTable::isEmptyL(int aCol, int aRow)
{
    if(aCol<0 || aRow<0 || aCol>8 || aRow>8) {emit error("105(isEmptyL)");return false;}

        if(table[aCol][aRow]==0)
        return true;
        else
        return false;
}
//---------------------------------------------------------------------------
//Sets number in table. Won't check if it is a right number
void CSudokuTable::setNumL(int aNum, int aCol, int aRow)
{
        //Note: number may be zero for empty cel
        if(aNum<0 || aCol<0 || aRow<0 || aNum>9 || aCol>8 || aRow>8) {emit error("106(setNumL)");return ;}
        table[aCol][aRow]=aNum;
        iLastPlace.setX(aCol);
        iLastPlace.setY(aRow);

}

//---------------------------------------------------------------------------
//returns number in given cordinates
int CSudokuTable::getNumL(int aCol, int aRow)
{
        if(aCol<0 || aRow<0 || aCol>8 || aRow>8) {emit error("107(getNumL)");return -1;}
        return table[aCol][aRow];
}
//---------------------------------------------------------------------------
//Generates table with all numbers in random, but correct order
void CSudokuTable::generateFullTableL()
{
        bool tableFinished = false;

        while(!tableFinished)
        {
                //Clears table
                clearTable();
                //Counter to stop trying fill table forever
                int safetyBreak=0;
                for(int row=0;row<9;row++)
                {
                        for(int col=0;col<9;col++)
                        {
                                int rando=random()+1;
                                int count=0;
                                while(isNumInRowL(rando,row) || (isNumInColL(rando,col)) || isNumInCellL(rando,col,row))
                                {
                                        rando=random()+1;
                                        count++;
                                        if(count>20)//Dont do forever
                                        {
                                                row--;
                                                rando=-1;
                                                break;
                                        }
                                }
                                if(rando<1)
                                {
                                        clearRow(row+1);
                                        break;
                                }
                                table[col][row]=rando;
                        }
                        safetyBreak++;
                        if(safetyBreak>50) {break;  }
                }
                if(!isEmptyL(8,8)) tableFinished=true;

        }

}
//---------------------------------------------------------------------------
//finds double numbers in the same row,column or Cell
bool CSudokuTable::isErrorInTableL(){
        bool error=false;
        for(int row=0;row<9;row++){
                for(int col=0;col<9;col++){
                        int num=table[col][row];
                        if (num!=0)
                        {
                                table[col][row]=0; //Zero for testing time
                                if(isNumInCellL(num,col,row)) error=true;
                                if(isNumInRowL(num,row))  error=true;
                                if(isNumInColL(num,col))  error=true;

                                table[col][row]=num; //return to orginal number
                                if(error) return true;
                        }

                }
        }
        return false;
}
//---------------------------------------------------------------------------
//removes random numbers from table
void CSudokuTable::removeNumbers(int aAmount)
{
        for(int k=0;k<aAmount;k++)
        {
                int col=random();
                int row=random();
                if(table[col][row]==0) k--;
                else table[col][row]=0;
                if(isTableEmpty()) return;
        }
}
//---------------------------------------------------------------------------
//Removes as many numbers from table as possible while table is still solvable
void CSudokuTable::removeAllNumbersL()
{
        int mRow=0;
        int mCol=0;
        for(int row=2;row<11;row++){
                for(int col=2;col<11;col++){
                        if(row==9)mRow=0;
                        if(col==9)mCol=0;
                        if(row==10)mRow=1;
                        if(col==10)mCol=1;
                        if(row<9) mRow=row;
                        if(col<9) mCol=col;
                        int mem=0;
                        mem =table[mRow][mCol];
                        table[mRow][mCol]=0;
                        if(!isTableSolvableL()) table[mRow][mCol]=mem;
                }
        }
}
//---------------------------------------------------------------------------
// find correct numbers to table, go thorough all Rows and columns untill 1 number is found
bool CSudokuTable::fillOneNumberL()
{
        if(isErrorInTableL()) return false;
        for(int i=1;i<10;i++){
                for(int j=0;j<9;j++){
                        bool match = tryNumberToColL(i,j);
                        if(match) return true;
                        match = tryNumberToRowL(i,j);
                        if(match) return true;

                }
        }

        for(int row=0;row<9;row++){
                for(int col=0;col<9;col++){
                        if(table[col][row]==0)
                        {
                                int count=0;
                                int mRow=-1;
                                int mCol=-1;
                                int mNum=0;
                                for(int i=1;i<10;i++){
                                        if(!isNumInAnyDirectionL(i,col,row)){count++;mRow=row;mCol=col;mNum=i;}
                                }
                                if(count==1) {setNumL(mNum,mCol,mRow);return true;}
                        }
                }
        }
        return false;
}
//---------------------------------------------------------------------------
// find correct numbers to table, go thorough all Rows once
bool CSudokuTable::fillRowL()
{
        bool found = false;
        for(int i=1;i<10;i++){
                for(int j=0;j<9;j++){
                        bool match = tryNumberToColL(i,j);
                        if(match) found=true;

                }
        }
        return found;
}
//---------------------------------------------------------------------------
// find correct numbers to table, go thorough all columns once
bool CSudokuTable::fillColL()
{
        bool found = false;
        for(int i=1;i<10;i++){
                for(int j=0;j<9;j++){
                        bool match = tryNumberToRowL(i,j);
                        if(match) found=true;
                }
        }
        return found;
}
//---------------------------------------------------------------------------
// find correct numbers to table, go thorough all 81 places once
bool CSudokuTable::fillAllL()
{
        bool found =false;
        for(int row=0;row<9;row++){
                for(int col=0;col<9;col++){
                        int count=0;
                        int mRow=-1;
                        int mCol=-1;
                        int mNum=0;
                        if(table[col][row]==0)
                        {
                                for(int i=1;i<10;i++){
                                        if(!isNumInAnyDirectionL(i,col,row)){count++;mRow=row;mCol=col;mNum=i;}
                                }
                                if(count==1) {setNumL(mNum,mCol,mRow);found=true;}
                        }
                }
        }
        return found;
}
//---------------------------------------------------------------------------
// find correct numbers to table, go thorough whole table as many times as possible
//return false if all numbers can't be found. Leaves table partialy complete.
bool CSudokuTable::fillWholeTableL()
{
        bool conti=true;
        bool c1=true;
        bool c2=true;
        bool c3=true;
        while(conti)
        {
                c1=fillAllL();
                c2=fillColL();
                c3=fillRowL();
                conti = false;
                if(c1||c2||c3) conti=true;
        }

        return isTableFull();
}
//---------------------------------------------------------------------------
//tries to but number in given column, in any place
bool CSudokuTable::tryNumberToColL(int aNum,int aCol)
{
    if(aNum<1 || aCol<0 || aNum>9 || aCol>8) {emit error("108(tryNumberToCol)");return false;}
        int row=0;
        int foundPlace=-1;//Paikka johon annettu numero sopeisi
        if(isNumInColL(aNum,aCol)) return false; //jos numero on jo sarakkeessa niin poistutaan
        //Kydn jokainen rivi lpi
        for(row=0;row<9;row++)
        {
                if(isEmptyL(aCol,row) && !isNumInRowL(aNum,row) && !isNumInCellL(aNum,aCol,row))
                {
                        if(foundPlace>-1) return false; //Numero sopeisi kahteen paikkaan, joten sit ei voida hyvksy.
                        foundPlace=row;
                }

        }
        if(foundPlace==-1) return false;//{emit error("120 ");return false;}//User::Leave(KErrArgument);//Tt ei pitisi ikin tapahtua??
        setNumL(aNum,aCol,foundPlace);

        return true;
}

//---------------------------------------------------------------------------
//tries to but number in given row, in any place
bool CSudokuTable::tryNumberToRowL(int aNum, int aRow){
    if(aNum<1 || aRow<0 || aNum>9 || aRow>8) {emit error("109(tryNumberToRowL)");return false;}
        int col=0;
        int foundPlace=-1;//Paikka johon annettu numero sopeisi
        if(isNumInRowL(aNum,aRow)) return false; //jos numero on jo rivill niin poistutaan
        //Kydn jokainen sarake lpi
        for(col=0;col<9;col++)
        {
                if(isEmptyL(col,aRow) && !isNumInColL(aNum,col) && !isNumInCellL(aNum,col,aRow))
                {
                        if(foundPlace>-1) return false; //Numero sopeisi kahteen paikkaan, joten sit ei voida hyvksy.
                        foundPlace=col;
                }

        }
        if(foundPlace==-1) return false;//{emit error("110 ");return false;}//User::Leave(KErrArgument);//Tt ei pitisi ikin tapahtua??
        setNumL(aNum,foundPlace,aRow);

        return true;
}

//---------------------------------------------------------------------------
bool CSudokuTable::isTableEmpty(){
        for(int row=0;row<9;row++)
        {
                for(int col=0;col<9;col++)
                {
                        if(table[col][row]!=0) return false;
                }
        }
        return true;
}
//---------------------------------------------------------------------------
bool CSudokuTable::isTableFull(){
        for(int row=0;row<9;row++)
        {
                for(int col=0;col<9;col++)
                {
                        if(table[col][row]==0) return false;
                }
        }
        return true;
}
//---------------------------------------------------------------------------
//How many numbers are missing from table
int CSudokuTable::missingNumbers(){
        int counter=0;
        for(int row=0;row<9;row++)
        {
                for(int col=0;col<9;col++)
                {
                        if(table[col][row]==0) counter++;;
                }
        }
        return counter;
}
//---------------------------------------------------------------------------
void CSudokuTable::copySudokuTableL(CSudokuTable* aTable)
{
        for(int row=0;row<9;row++){
                for(int col=0;col<9;col++){
                        aTable->setNumL(getNumL(col,row),col,row);
                }
        }
}
//---------------------------------------------------------------------------
int CSudokuTable::random()
{
/*
        //For Symbian S60
        int retNum=-1;
        while(retNum<0 ||retNum>8)
        {
                int num=Math::Rand(iRandomSeed);
                if(num<10)num=12;
                TBuf<32> tex;
                tex.Num(num);
                retNum = tex[1]-48;
                TBuf<5> tex1;
                tex1.Num(retNum);
                //	RDebug::Print(tex1);
        }
        return retNum;
        */
    return (qrand() % 9 );
}
//---------------------------------------------------------------------------
bool CSudokuTable::isTableSolvableL()
{
        if(isErrorInTableL()) return false;
        CSudokuTable* temp = new CSudokuTable();
        copySudokuTableL(temp);
        bool ret = temp->fillWholeTableL();
        delete temp;
        return ret;
}
//---------------------------------------------------------------------------
bool CSudokuTable::isMemoryNumber(int aNum, int aCol,int aRow)
{
    if(aNum<1 || aNum>9) {emit error("1__(isMemoryNumber)");return false ;}
    if(aNum<0 || aCol<0 || aRow<0 || aNum>9 || aCol>8 || aRow>8) {emit error("1__(isMemoryNumber)");return false ;}
   int i=0;
    switch(aNum)
   {
   case 1:
       i = memoryTable[aCol][aRow] & 0x1;
       break;
   case 2:
       i = memoryTable[aCol][aRow] & 0x2;
       break;
   case 3:
       i = memoryTable[aCol][aRow] & 0x4;
       break;
   case 4:
       i = memoryTable[aCol][aRow] & 0x8;
       break;
   case 5:
       i = memoryTable[aCol][aRow] & 0x10;
       break;
   case 6:
       i = memoryTable[aCol][aRow] & 0x20;
       break;
   case 7:
       i = memoryTable[aCol][aRow] & 0x40;
       break;
   case 8:
       i = memoryTable[aCol][aRow] & 0x80;
       break;
   case 9:
       i = memoryTable[aCol][aRow] & 0x100;
       break;
   default:
       return false;
       break;
   }
    if(i!=0) return true;
    return false;
}
//---------------------------------------------------------------------------
  bool CSudokuTable::setMemoryNumber(int aNum, int aCol,int aRow)
  {
    if(aNum<1 || aNum>9) {emit error("1__(setMemoryNumber)");return false ;}
    if(aNum<0 || aCol<0 || aRow<0 || aNum>9 || aCol>8 || aRow>8) {emit error("1__(setMemoryNumber)");return false ;}
   switch(aNum)
   {
   case 1:
       memoryTable[aCol][aRow] = memoryTable[aCol][aRow] | 0x1;
       break;
   case 2:
       memoryTable[aCol][aRow] = memoryTable[aCol][aRow] | 0x2;
       break;
   case 3:
       memoryTable[aCol][aRow] = memoryTable[aCol][aRow] | 0x4;
       break;
   case 4:
       memoryTable[aCol][aRow] = memoryTable[aCol][aRow] | 0x8;
       break;
   case 5:
       memoryTable[aCol][aRow] = memoryTable[aCol][aRow] | 0x10;
       break;
   case 6:
       memoryTable[aCol][aRow] = memoryTable[aCol][aRow] | 0x20;
       break;
   case 7:
       memoryTable[aCol][aRow] = memoryTable[aCol][aRow] | 0x40;
       break;
   case 8:
       memoryTable[aCol][aRow] = memoryTable[aCol][aRow] | 0x80;
       break;
   case 9:
       memoryTable[aCol][aRow] = memoryTable[aCol][aRow] | 0x100;
       break;
   default:
       break;
   }

  }

//---------------------------------------------------------------------------
bool CSudokuTable::removeMemoryNumber(int aNum, int aCol,int aRow)
{
    if(aNum<1 || aNum>9) {emit error("1__(removeMemoryNumber)");return false ;}
    if(aNum<0 || aCol<0 || aRow<0 || aNum>9 || aCol>8 || aRow>8) {emit error("1__(removeMemoryNumber)");return false ;}
   switch(aNum)
   {
   case 1:
       memoryTable[aCol][aRow] = memoryTable[aCol][aRow] & ~0x1;
       break;
   case 2:
       memoryTable[aCol][aRow] = memoryTable[aCol][aRow] & ~0x2;
       break;
   case 3:
       memoryTable[aCol][aRow] = memoryTable[aCol][aRow] & ~0x4;
       break;
   case 4:
       memoryTable[aCol][aRow] = memoryTable[aCol][aRow] & ~0x8;
       break;
   case 5:
       memoryTable[aCol][aRow] = memoryTable[aCol][aRow] & ~0x10;
       break;
   case 6:
       memoryTable[aCol][aRow] = memoryTable[aCol][aRow] & ~0x20;
       break;
   case 7:
       memoryTable[aCol][aRow] = memoryTable[aCol][aRow] & ~0x40;
       break;
   case 8:
       memoryTable[aCol][aRow] = memoryTable[aCol][aRow] & ~0x80;
       break;
   case 9:
       memoryTable[aCol][aRow] = memoryTable[aCol][aRow] & ~0x100;
       break;
   default:
       break;
   }


}

//---------------------------------------------------------------------------
void CSudokuTable::removeMemoryNumbers(int aCol, int aRow)
{
                    memoryTable[aCol][aRow]=0;
}

//---------------------------------------------------------------------------
void CSudokuTable::loadFromFileL(bool aAuto)
{
/*
        RFs fs;
        fs.Connect();
        RFileReadStream readStream;
        TBuf<30> fileName;
        _LIT(KFileName1,"SudokuSave.dat");
        _LIT(KFileName2,"SudokuSaveAuto.dat");
        if(aAuto) fileName = KFileName2; else fileName = KFileName1;

        TFileName mapFileName(fileName);


        int er=3;

        er = readStream.Open(fs,mapFileName,EFileRead);

        readStream.PushL();

        if(er==KErrNone)
        {

                for(int row=0;row<9;row++)
                {
                        for(int col=0;col<9;col++)
                        {
                                table[row][col] = readStream.ReadInt16L();
                                if(table[row][col]<0 || table[row][col]>9)
                                {
                                        clearTable();
                                        User::Leave(KErrCorrupt);
                                }
                        }
                }

        }
        readStream.Pop();
        readStream.Close();
        fs.Close();
        if(er!=KErrNone) {
                User::Leave(er);
        }
        */
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void CSudokuTable::saveToFileL(bool aAuto)
{
    /*
        RFs fs;
        fs.Connect();
        RFileWriteStream writeStream;
        TBuf<30> fileName;
        _LIT(KFileName1,"SudokuSave.dat");
        _LIT(KFileName2,"SudokuSaveAuto.dat");
        if(aAuto) fileName = KFileName2; else fileName = KFileName1;

        TFileName mapFileName(fileName);

        int er=3;
        er = writeStream.Create(fs,mapFileName,EFileWrite);
        if(er!=KErrNone)
        {
                er = writeStream.Open(fs,mapFileName,EFileWrite);
        }
        writeStream.PushL();

        if(er==KErrNone)
        {
                for(int row=0;row<9;row++)
                {
                        for(int col=0;col<9;col++)
                        {
                                writeStream.WriteInt16L(static_cast<TUint16>(table[row][col]));
                                //writeStream.WriteInt16L(static_cast<TUint16>(table[i].iY));
                        }
                        writeStream.CommitL();
                }
        }
        writeStream.Pop();
        writeStream.Release();
        fs.Close();
        */
}
