#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>


class CSudokuTable;
class SudokuTableWidget;
class SudokuSelectNumberWidget;
class QWidget;
class QPushButton;
class QLabel;
class QRadioButton;
class MainWindow : public QMainWindow
{
    Q_OBJECT

public slots:
    void changeNumber(int aX,int aY);
    //void numberChanged(int aNum);
    void showError(QString aString);
    void newGame();
    void solveOne();
    void solveTable();
    void changeSettings();
    void repaintElements();
    void toggleNumberTypes();
    void checkTable();
void aboutt();
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:

    CSudokuTable *iTable;
    SudokuTableWidget *iTableWidget;
    SudokuSelectNumberWidget *iSelectNumberWidget;
    QWidget *iMainWidget;
    QPushButton *iNewGameButton;
    QPushButton *iSolveOneButton;
    QPushButton *iSolveAllButton;
    QPushButton *iChangeSettingsButton;
    QLabel *iSolvableText;
    QRadioButton *iNormalNumberRadioButton;
    QRadioButton *iMarkupNumberRadioButton;
    bool iSettingAutoCheck;
    bool iCriticalError;
    //bool iPracticeMode;
};

#endif // MAINWINDOW_H
