#!/usr/bin/env python
# -*- coding: UTF-8 -*-
#
#    lib/client.py
#
#    This file is part of Mass-Transit
#
#    Copyright (C) 2010 Thibault Cohen
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#


from urllib import urlopen, urlencode
from lib import config
from lib import lib_masstransit

import urllib2
import simplejson as json
from datetime import datetime

import socket


config = config.Config()

# set timeout in seconds
timeout = 5
socket.setdefaulttimeout(timeout)


def get_server_version():
    url = unicode(config.value("server").toString())
    data = json.dumps(
            {
                "params" : {},
              "id" : 1,
            }
        )
    req = urllib2.Request(
            url + "/mt/version",
            data=data,
            headers={'content-type': 'application/x-json'})
    try:
        response = urllib2.urlopen(req)
    except urllib2.HTTPError, e:
        message = 'Error: ' + unicode(e.code) + " - " + unicode(e.msg)
        lib_masstransit.banner_notification(unicode(message))
    except urllib2.URLError, e:
        if len(e.reason.args) >= 2:
            message = 'Error: ' + unicode(e.reason.args[0]) + \
                    " - " + unicode(e.reason.args[1])
        elif len(e.reason.args) == 1:
            message = 'Error: ' + unicode(e.reason.args[0])
        lib_masstransit.banner_notification(unicode(message))
    obj = json.loads(response.read())
    return obj


def get_protocol_version():
    url = unicode(config.value("server").toString())
    data = json.dumps(
            {
              "params" : {},
              "id" : 1,
            }
        )
    req = urllib2.Request(
            url + "/mt/protocol_version",
            data=data,
            headers={'content-type': 'application/x-json'})
    try:
        response = urllib2.urlopen(req)
    except urllib2.HTTPError, e:
        message = 'Error: ' + unicode(e.code) + " - " + unicode(e.msg)
        lib_masstransit.banner_notification(unicode(message))
    except urllib2.URLError, e:
        message = 'Error: ' + unicode(e.reason.args[0]) + \
                    " - " + unicode(e.reason.args[1])
        lib_masstransit.banner_notification(unicode(message))
    obj = json.loads(response.read())
    return obj


def get_supported_company():
    url = unicode(config.value("server").toString())
    data = json.dumps(
        {
          "params" : {},
          "id" : 1,
        }
    )
    req = urllib2.Request(
                url + "/mt/supported_towns",
                data=data,
                headers={'content-type': 'application/x-json'}
                    )
    try:
        response = urllib2.urlopen(req)
    except urllib2.HTTPError, e:
        message = 'Error: ' + unicode(e.code) + " - " + unicode(e.msg)
        lib_masstransit.banner_notification(unicode(message))
    except urllib2.URLError, e:
        message = 'Error: ' + unicode(e.reason.args[0]) + \
                    " - " + unicode(e.reason.args[1])
        lib_masstransit.banner_notification(unicode(message))
    obj = json.loads(response.read())
    return obj


def get_bus_lines(company_id):
    url = unicode(config.value("server").toString())
    company_id = unicode(company_id)
    data = json.dumps(
            {
              "params" : {"company_id" : company_id},
              "id" : 1,
            }
        )
    req = urllib2.Request(
                url + "/mt/bus_lines",
                data=data,
                headers={'content-type': 'application/x-json'}
                    )
    try:
        response = urllib2.urlopen(req)
    except urllib2.HTTPError, e:
        message = 'Error: ' + unicode(e.code) + " - " + unicode(e.msg)
        lib_masstransit.banner_notification(unicode(message))
    except urllib2.URLError, e:
        message = 'Error: ' + unicode(e.reason.args[0]) + \
                    " - " + unicode(e.reason.args[1])
        lib_masstransit.banner_notification(unicode(message))
    obj = json.loads(response.read())
    return obj


def get_bus_directions(company_id):
    url = unicode(config.value("server").toString())
    company_id = unicode(company_id)
    data = json.dumps(
            {
              "params" : {"company_id" : company_id},
              "id" : 1,
            }
        )
    req = urllib2.Request(
                url + "/mt/bus_directions",
                data=data,
                headers={'content-type': 'application/x-json'}
                    )
    try:
        response = urllib2.urlopen(req)
    except urllib2.HTTPError, e:
        message = 'Error: ' + unicode(e.code) + " - " + unicode(e.msg)
        lib_masstransit.banner_notification(unicode(message))
    except urllib2.URLError, e:
        message = 'Error: ' + unicode(e.reason.args[0]) + \
                    " - " + unicode(e.reason.args[1])
        lib_masstransit.banner_notification(unicode(message))
    obj = json.loads(response.read())
    return obj


def get_bus_stops(company_id, line, direction):
    url = unicode(config.value("server").toString())
    company_id = unicode(company_id)
    line = unicode(line)
    direction = unicode(direction)
    data = json.dumps(
            {
            "params": { "company_id" : company_id,
                        "line" : line,
                        "direction" : direction,
                        },
                        "id": 1,
             })
    req = urllib2.Request(
                url + "/mt/bus_stops",
                data=data,
                headers={'content-type': 'application/x-json'}
                    )
    try:
        response = urllib2.urlopen(req)
    except urllib2.HTTPError, e:
        message = 'Error: ' + unicode(e.code) + " - " + unicode(e.msg)
        lib_masstransit.banner_notification(unicode(message))
    except urllib2.URLError, e:
        message = 'Error: ' + unicode(e.reason.args[0]) + \
                    " - " + unicode(e.reason.args[1])
        lib_masstransit.banner_notification(unicode(message))
    obj = json.loads(response.read())
    return obj


def get_next_bus_passing_times(company_id, bus_stop):
    url = unicode(config.value("server").toString())
    company_id = unicode(company_id)
    bus_stop = unicode(bus_stop)
    now = datetime.now().strftime('%Y-%m-%dT%H:%M:%S')
    data = json.dumps(
            { "params": { "datetime" : now,
                        "company_id" : company_id,
                        "bus_stop" : bus_stop,
                    },
            "id": 1,
            }
        )
    req = urllib2.Request(
                url + "/mt/next_bus_passing_times",
                data=data,
                headers={'content-type': 'application/x-json'}
                    )
    try:
        response = urllib2.urlopen(req)
    except urllib2.HTTPError, e:
        message = 'Error: ' + unicode(e.code) + " - " + unicode(e.msg)
        lib_masstransit.banner_notification(unicode(message))
    except urllib2.URLError, e:
        message = 'Error: ' + unicode(e.reason.args[0]) + \
                    " - " + unicode(e.reason.args[1])
        lib_masstransit.banner_notification(unicode(message))

    obj = json.loads(response.read())
    return obj

