#!/usr/bin/env python
# -*- coding: UTF-8 -*-
#
#    stopcodelist.py
#
#    This file is part of Mass-Transit
#
#    Copyright (C) 2010 Thibault Cohen
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

from PyQt4 import QtCore, QtGui
from module import stm

class UI_StopCodeList(QtGui.QMainWindow):
    def __init__(self, line, direction, parent=None, root=None):
        QtGui.QMainWindow.__init__(self, parent=parent)
        self.parent = parent
        self.root = root
        self.list_widget = QtGui.QListWidget()
        self.setCentralWidget(self.list_widget)
        self.setWindowTitle("Mass-Transit - Bus Stop list")
        self.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow, True)

        stop_code_list = stm.getBusStopList(direction,line)
        # Fill list
        for stop_code in stop_code_list:
            name = stop_code[0] + " - " + stop_code[1]
            new_item = QtGui.QListWidgetItem(unicode(name), self.list_widget)
            new_item.setData(QtCore.Qt.UserRole, QtCore.QVariant(stop_code[0])) 
            self.list_widget.addItem(new_item)

        # Signals
        QtCore.QObject.connect(self.list_widget, QtCore.SIGNAL("itemClicked(QListWidgetItem *)"), self.show_stop_code_progress)

    def show_stop_code_progress(self, item):
        self.setAttribute(QtCore.Qt.WA_Maemo5ShowProgressIndicator, True)
        self.item = item
        QtCore.QTimer.singleShot(1,self.show_stop_code) 
    
    def show_stop_code(self):
        stop_code = self.item.data(QtCore.Qt.UserRole).toString()
        self.root.change_mode(mode="stop_code", stop_code=stop_code, parent=self)
        self.setAttribute(QtCore.Qt.WA_Maemo5ShowProgressIndicator, False)

    def closeEvent(self, event):
        self.root.mode = "favorites"

