#!/usr/bin/env python
# -*- coding: UTF-8 -*-
#
#    lib_masstransit.py
#
#    This file is part of Mass-Transit
#
#    Copyright (C) 2010 Thibault Cohen
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

from time import time
try:
    import alarm
    import osso
except:
    pass


def banner_notification(message):
    osso_c = osso.Context("stm_notif", "0.0.1", False)
    note = osso.SystemNote(osso_c)
    note.system_note_infoprint(message)


def add_alarm(message, alarm_delta):
    event = alarm.Event()
    event.appid = 'stm'
    event.message = message
    #event.alarm_time = time() + 900
    # NOTE: test 10 seconds
    event.alarm_time = time() + alarm_delta

    action_snooze, action_stop = event.add_actions(2)
    action_stop.label = 'Stop'
    action_stop.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_NOP

    action_snooze.label = 'Snooze'
    action_snooze.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_SNOOZE

    cookie = alarm.add_event(event)

    return cookie
