#!/usr/bin/env python
# -*- coding: UTF-8 -*-
#
#    favoritelist.py
#
#    This file is part of Mass-Transit
#
#    Copyright (C) 2010 Thibault Cohen
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

from PyQt4 import QtCore, QtGui
from module import stm


class UI_FavoriteList(QtGui.QListWidget):
    def __init__(self, parent=None, root=None):
        QtGui.QListWidget.__init__(self, parent)
        self.parent = parent
        self.root = root

        self.stop_codes = self.root.config.get_favorites_stop_code()

        # Fill list
        self.fill_list()

        # Signals
        QtCore.QObject.connect(self, QtCore.SIGNAL("itemClicked(QListWidgetItem *)"), self.show_stop_code)

    def show_stop_code(self, item):
        stop_code = item.data(QtCore.Qt.UserRole).toString()
        self.root.change_mode(mode="stop_code", stop_code=stop_code)


    def fill_list(self):
        self.clear()
        for stop_code,values in self.stop_codes.items():
            name = stop_code + " - " + values
            new_item = QtGui.QListWidgetItem(name,self)
            new_item.setData(QtCore.Qt.UserRole, QtCore.QVariant(stop_code))
            self.addItem(new_item)


    def focusInEvent(self, event):
        self.stop_codes = self.root.config.get_favorites_stop_code()
        self.fill_list()
