#include "config.h"

#ifndef _MAPPER_TYPES_H
#define _MAPPER_TYPES_H

#include <math.h>
#include <gtk/gtk.h>
#include <curl/multi.h>

/** This enum defines the possible font sizes. */
typedef enum {
	INFO_FONT_XXSMALL,
	INFO_FONT_XSMALL,
	INFO_FONT_SMALL,
	INFO_FONT_MEDIUM,
	INFO_FONT_LARGE,
	INFO_FONT_XLARGE,
	INFO_FONT_XXLARGE,
	INFO_FONT_ENUM_COUNT
} InfoFontSize;
gchar *INFO_FONT_TEXT[INFO_FONT_ENUM_COUNT];

/** This enum defines all of the key-customizable actions. */
typedef enum {
	CUSTOM_ACTION_PAN_NORTH,
	CUSTOM_ACTION_PAN_WEST,
	CUSTOM_ACTION_PAN_SOUTH,
	CUSTOM_ACTION_PAN_EAST,
	CUSTOM_ACTION_TOGGLE_AUTOCENTER,
	CUSTOM_ACTION_ZOOM_IN,
	CUSTOM_ACTION_ZOOM_OUT,
	CUSTOM_ACTION_TOGGLE_FULLSCREEN,
	CUSTOM_ACTION_TOGGLE_TRACKS,
	CUSTOM_ACTION_TOGGLE_SCALE,
	CUSTOM_ACTION_TOGGLE_POI,
	CUSTOM_ACTION_CHANGE_REPO,
	CUSTOM_ACTION_ROUTE_DISTNEXT,
	CUSTOM_ACTION_ROUTE_DISTLAST,
	CUSTOM_ACTION_TRACK_BREAK,
	CUSTOM_ACTION_TRACK_DISTLAST,
	CUSTOM_ACTION_TRACK_DISTFIRST,
	CUSTOM_ACTION_TOGGLE_GPS,
	CUSTOM_ACTION_TOGGLE_GPSINFO,
	CUSTOM_ACTION_TOGGLE_SPEEDLIMIT,
	CUSTOM_ACTION_ENUM_COUNT
} CustomAction;
gchar *CUSTOM_ACTION_TEXT[CUSTOM_ACTION_ENUM_COUNT];

/** This enum defines all of the customizable keys. */
typedef enum {
	CUSTOM_KEY_UP,
	CUSTOM_KEY_LEFT,
	CUSTOM_KEY_DOWN,
	CUSTOM_KEY_RIGHT,
	CUSTOM_KEY_SELECT,
	CUSTOM_KEY_INCREASE,
	CUSTOM_KEY_DECREASE,
	CUSTOM_KEY_FULLSCREEN,
	CUSTOM_KEY_ESC,
	CUSTOM_KEY_ENUM_COUNT
} CustomKey;
gchar *CUSTOM_KEY_GCONF[CUSTOM_KEY_ENUM_COUNT];
gchar *CUSTOM_KEY_ICON[CUSTOM_KEY_ENUM_COUNT];
CustomAction CUSTOM_KEY_DEFAULT[CUSTOM_KEY_ENUM_COUNT];

/** This enum defines all of the colorable objects. */
typedef enum {
	COLORABLE_MARK,
	COLORABLE_MARK_VELOCITY,
	COLORABLE_MARK_OLD,
	COLORABLE_TRACK,
	COLORABLE_TRACK_MARK,
	COLORABLE_TRACK_BREAK,
	COLORABLE_ROUTE,
	COLORABLE_ROUTE_WAY,
	COLORABLE_ROUTE_BREAK,
	COLORABLE_POI,
	COLORABLE_ENUM_COUNT
} Colorable;
gchar *COLORABLE_GCONF[COLORABLE_ENUM_COUNT];
GdkColor COLORABLE_DEFAULT[COLORABLE_ENUM_COUNT];

typedef enum {
	SPEED_LOCATION_TOP_LEFT,
	SPEED_LOCATION_TOP_RIGHT,
	SPEED_LOCATION_BOTTOM_RIGHT,
	SPEED_LOCATION_BOTTOM_LEFT,
	SPEED_LOCATION_ENUM_COUNT
} SpeedLocation;
gchar *SPEED_LOCATION_TEXT[SPEED_LOCATION_ENUM_COUNT];

typedef struct _RouteDownloadData RouteDownloadData;
struct _RouteDownloadData {
	gchar *bytes;
	guint bytes_read;
};

/** Data used during the asynchronous automatic route downloading operation. */
typedef struct _AutoRouteDownloadData AutoRouteDownloadData;
struct _AutoRouteDownloadData {
	gboolean enabled;
	gboolean in_progress;
	gchar *dest;
	CURL *curl_easy;
	gchar *src_str;
	RouteDownloadData rdl_data;
};

typedef struct _BrowseInfo BrowseInfo;
struct _BrowseInfo {
	GtkWidget *dialog;
	GtkWidget *txt;
};

#endif
