/*
 * GtkCompass: Display a compass with heading and target
 * Copyright (C) 2007 Kaj-Michael Lang
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GTK_COMPASS_H__
#define __GTK_COMPASS_H__

#include <gtk/gtk.h>

#include "gpsdata.h"

G_BEGIN_DECLS

#define GTK_COMPASS_TYPE			(gtk_compass_get_type ())
#define GTK_COMPASS(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_COMPASS_TYPE, GtkCompass))
#define GTK_COMPASS_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_COMPASS_TYPE, GtkCompassClass))
#define GTK_IS_COMPASS(obj)			(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_COMPASS_TYPE))

typedef struct _GtkCompass			GtkCompass;
typedef struct _GtkCompassClass		GtkCompassClass;

struct _GtkCompass {
	GtkDrawingArea widget;
	GdkGC *gc_h;
	GdkGC *gc_w;
	GdkGC *gc_d;
	guint width, height;
	guint size;
	guint xoffset, yoffset;

	PangoContext *context;
	PangoLayout *layout;
	PangoFontDescription *fontdesc;

	GpsData *data;
	gfloat heading;
	gboolean dest_valid;
	gboolean way_valid;
	gfloat dest_heading;
	gfloat way_heading;
	gint esid;
};

struct _GtkCompassClass {
	GtkWidgetClass parent_class;
};

GType gtk_compass_get_type(void);
GtkWidget* gtk_compass_new(GpsData *data);
void gtk_compass_refresh(GtkWidget *widget);
void gtk_compass_set_way_heading(GtkWidget *widget, gboolean valid, gfloat heading);
void gtk_compass_set_dest_heading(GtkWidget *widget, gboolean valid, gfloat heading);

G_END_DECLS

#endif /* __GTK_COMPASS_H__ */
