#ifndef _MAPPER_TRACK_H
#define _MAPPER_TRACK_H

#include <glib.h>
#include "filter.h"

Path *_track;

void track_init(void);
void track_deinit(void);

gboolean track_add(GpsData *gps);
gboolean track_insert_break(Path *path);
gboolean track_insert_mark(Path *path);
gboolean track_save(Path *path);
gboolean track_open(void);
void track_clear(Path *path);

void track_show_distance_from_first(Path *path);
void track_show_distance_from_last(Path *path);
void track_show_distance_from(Path *path, Point *point);

#endif
