PRAGMA page_size=4096;
PRAGMA encoding = "UTF-8"; 

create table nodes (
	nid	int primary key,
	ilat	int not null,
	ilon	int not null,
	rlat	real not null,
	rlon	real not null,
	l	int not null default 0,
	f	int not null default 0
);

create table node_tags (
	nid	int not null,
	t text
);

create table way_tags (
	wid int not null,
	t text
);

create table way (
	wid		int primary key,
	type	int not null,
	nodes	int not null,
	flags	int not null,
	speed	int not null default 0,
	isin_c	int not null default 0,
	isin_p	int not null default 0,
	lat		real not null,
	lon		real not null
);

create table way_updates (
	wid		int primary key,
	utime	int not null,
	notes	text
);

create table way_n2n (
	wid		int not null,
	f		int not null,
	t		int not null
);

create table way_names (
	wid		int primary key,
	name	varchar(256),
	norm	varchar(256)
);

create table way_pc (
	wid		int primary key,
	pc		varchar(256)
);

create table way_names_nls (
	wid		int not null,
	lang	char(4) not null,
	name	varchar(256),
	norm	varchar(256)
);

create table way_ref (
	rid		int primary key,
	ref		varchar(32),
	int_ref	varchar(32)
);

create table places (
	nid		int primary key,
	type	int not null,
	name	text,
	isin_p	int not null,
	isin_c	int not null
);

create table poi (
	poi_id	INTEGER PRIMARY KEY AUTOINCREMENT,
	lat		real not null,
	lon		real not null,
	elev	real default 0.0,
	label	text,
	desc	text,
	url		text,
	postal_code text,
	public	int default 1,
	source	int default 0,
	cat_id	int,
	osm_id	int default 0,
	isin_p	int default 0,
	isin_c	int default 0,
	priority int default 2,
	addtime	int default 0
);

create table category (
	cat_id		INTEGER PRIMARY KEY AUTOINCREMENT,
	pcat_id		int not null default 0,
	priority	int not null default 2,
	label		text,
	desc		text,
	color		char(6) not null default '#AAAA40',
	icon		varchar(32),
	enabled		int not null default 1
);

