#include "config.h"

#ifndef _MAPPER_ROUTE_H
#define _MAPPER_ROUTE_H

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <stddef.h>
#include <locale.h>
#include <math.h>
#include <errno.h>
#include <sys/wait.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <dbus/dbus-glib.h>

#include "utils.h"
#include "mapper-types.h"

/** The current route. */
Path *_route;

/** Data for tracking waypoints for the purpose of announcement. */

/* _near_point is the route point to which we are closest. */
Point *_near_point;
guint64 _near_point_dist_squared;

/* _next_way is what we currently interpret to be the next waypoint. */
WayPoint *_next_way;

/* _next_wpt is the route point immediately following _next_way. */
Point *_next_wpt;
guint64 _next_wpt_dist_squared;

/** The singleton auto-route-download data. */
AutoRouteDownloadData _autoroute_data;

void route_init(void);
void route_deinit(void);

gboolean route_open_file(void);
gboolean route_save(void);
gboolean route_download(void);
void route_clear(void);

void route_check_waypoint_announce(GpsData *gps);
void route_autoroute_check(void);

void route_find_nearest_point(void);
WayPoint *route_find_nearest_waypoint(guint unitx, guint unity);

gboolean route_update_nears(gboolean quick);

gdouble route_get_distance_to(Point *point);
gboolean route_show_distance_to(Point * point);
void route_show_distance_to_last();
void route_show_distance_to_next();

void route_cancel_autoroute(gboolean temporary);

#endif
